<?php

if (!function_exists('app_url')) {
    /**
     * Identifie dynamiquement l'institution appelante via l'URL
     *
     * @return string
     */
    function app_url(): string
    {
        $request = request();
        $host = $request->getHost();
        
        // Vérifier si c'est un sous-domaine
        $parts = explode('.', $host);
        if (count($parts) >= 3) {
            $subdomain = $parts[0];
            
            // Vérifier dans la base de données
            $school = App\SmSchool::where('school_name', $subdomain)
                ->orWhere('slug', $subdomain)
                ->first();
                
            if ($school) {
                return $school->id;
            }
        }
        
        // Vérifier si c'est un domaine personnalisé
        $customDomain = \Modules\KouffeSaas\Models\SaasCustomDomain::where('domain', $host)
            ->where('is_active', true)
            ->where('is_verified', true)
            ->first();
            
        if ($customDomain) {
            return $customDomain->school_id;
        }
        
        // Retourner l'URL complète par défaut
        return $request->getSchemeAndHttpHost();
    }
}

if (!function_exists('get_school_id_from_url')) {
    /**
     * Obtient l'ID de l'école depuis l'URL
     *
     * @return int|null
     */
    function get_school_id_from_url(): ?int
    {
        $request = request();
        $host = $request->getHost();
        
        // Vérifier si c'est un sous-domaine
        $parts = explode('.', $host);
        if (count($parts) >= 3) {
            $subdomain = $parts[0];
            
            $school = App\SmSchool::where('school_name', $subdomain)
                ->orWhere('slug', $subdomain)
                ->first();
                
            if ($school) {
                return $school->id;
            }
        }
        
        // Vérifier si c'est un domaine personnalisé
        $customDomain = \Modules\KouffeSaas\Models\SaasCustomDomain::where('domain', $host)
            ->where('is_active', true)
            ->where('is_verified', true)
            ->first();
            
        if ($customDomain) {
            return $customDomain->school_id;
        }
        
        return null;
    }
}

