<?php

namespace Modules\KouffeSaas\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\KouffeSaas\Services\PaymentService;
use Modules\KouffeSaas\Models\SaasInvoice;

class PaymentController extends Controller
{
    protected $paymentService;

    public function __construct(PaymentService $paymentService)
    {
        $this->paymentService = $paymentService;
    }

    /**
     * Traite un paiement Stripe
     */
    public function processStripePayment(Request $request)
    {
        $request->validate([
            'invoice_id' => 'required|exists:saas_invoices,id',
            'payment_method_id' => 'required|string',
        ]);

        $result = $this->paymentService->processStripePayment(
            $request->invoice_id,
            $request->payment_method_id
        );

        if ($result['success']) {
            return response()->json($result);
        }

        return response()->json($result, 400);
    }

    /**
     * Traite un paiement PayPal
     */
    public function processPayPalPayment(Request $request)
    {
        $request->validate([
            'invoice_id' => 'required|exists:saas_invoices,id',
            'payment_id' => 'required|string',
        ]);

        $result = $this->paymentService->processPayPalPayment(
            $request->invoice_id,
            $request->payment_id
        );

        return response()->json($result);
    }

    /**
     * Page de retour après paiement
     */
    public function paymentReturn(Request $request)
    {
        return view('kouffesaas::payment.return');
    }
}

