<?php

namespace Modules\KouffeSaas\Middleware;

use Closure;
use Illuminate\Http\Request;
use Modules\KouffeSaas\Services\SubscriptionService;

class EnforceSubscriptionLimits
{
    protected $subscriptionService;

    public function __construct()
    {
        $this->subscriptionService = new SubscriptionService();
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $schoolId = $request->attributes->get('school_id') ?? $request->get('school_id');

        if (!$schoolId) {
            return $next($request);
        }

        // Vérifier les limites lors de l'ajout d'étudiants
        if ($request->isMethod('POST') && $request->routeIs('*student*store') || $request->routeIs('*student*create')) {
            $currentStudentCount = \App\Models\Student::where('school_id', $schoolId)->count();
            
            if (!$this->subscriptionService->enforceLimits($schoolId, 'students', $currentStudentCount)) {
                return response()->json([
                    'success' => false,
                    'message' => 'Limite d\'étudiants atteinte pour votre plan. Veuillez mettre à niveau votre abonnement.',
                ], 403);
            }
        }

        return $next($request);
    }
}

