@extends('backEnd.master')

@section('title', 'Tableau de bord - Kouffe SaaS')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Tableau de bord Abonnement</h4>
                </div>
                <div class="card-body">
                    @if($subscription)
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Plan actuel: {{ $subscription->plan->name }}</h5>
                                <p><strong>Statut:</strong> 
                                    <span class="badge badge-{{ $subscription->isActive() ? 'success' : 'danger' }}">
                                        {{ ucfirst($subscription->status) }}
                                    </span>
                                </p>
                                <p><strong>Date d'expiration:</strong> {{ $subscription->end_date->format('d/m/Y') }}</p>
                                <p><strong>Jours restants:</strong> {{ $subscription->daysRemaining() }}</p>
                            </div>
                            <div class="col-md-6">
                                <h5>Utilisation</h5>
                                <p><strong>Étudiants:</strong> {{ $usage['students'] }} 
                                    @if(!$subscription->plan->isUnlimitedStudents())
                                        / {{ $subscription->plan->max_students }}
                                    @else
                                        / Illimité
                                    @endif
                                </p>
                                <p><strong>Stockage:</strong> {{ number_format($usage['storage_gb'], 2) }} GB
                                    @if(!$subscription->plan->isUnlimitedStorage())
                                        / {{ $subscription->plan->max_storage_gb }} GB
                                    @else
                                        / Illimité
                                    @endif
                                </p>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-warning">
                            <p>Aucun abonnement actif. <a href="{{ route('kouffe-saas.school.plans') }}">Souscrire à un plan</a></p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Factures récentes</h4>
                </div>
                <div class="card-body">
                    @if($invoices->count() > 0)
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Numéro</th>
                                    <th>Montant</th>
                                    <th>Statut</th>
                                    <th>Date d'échéance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($invoices as $invoice)
                                    <tr>
                                        <td>{{ $invoice->invoice_number }}</td>
                                        <td>{{ number_format($invoice->amount, 2) }} {{ $invoice->currency }}</td>
                                        <td>
                                            <span class="badge badge-{{ $invoice->status === 'paid' ? 'success' : 'warning' }}">
                                                {{ ucfirst($invoice->status) }}
                                            </span>
                                        </td>
                                        <td>{{ $invoice->due_date->format('d/m/Y') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p>Aucune facture disponible</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

