<?php

namespace Modules\KouffeSaas\Console\Commands;

use Illuminate\Console\Command;
use Modules\KouffeSaas\Services\SubscriptionService;

class CheckSubscriptions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'kouffe-saas:check-subscriptions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Vérifie quotidiennement les abonnements expirés et tente le renouvellement automatique';

    protected $subscriptionService;

    public function __construct(SubscriptionService $subscriptionService)
    {
        parent::__construct();
        $this->subscriptionService = $subscriptionService;
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Vérification des abonnements...');

        try {
            $this->subscriptionService->checkSubscription();
            $this->info('Vérification terminée avec succès');
            return Command::SUCCESS;
        } catch (\Exception $e) {
            $this->error('Erreur lors de la vérification: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}

