<?php

namespace Modules\KouffeSaas\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Modules\KouffeSaas\Models\SaasSubscription;

class WipeSchoolData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'kouffe-saas:wipe-school {school_id : ID de l\'école} {--force : Force la suppression sans confirmation}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Supprime toutes les données d\'une école résiliée (basé sur db:wipe)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $schoolId = $this->argument('school_id');
        $force = $this->option('force');

        $subscription = SaasSubscription::where('school_id', $schoolId)
            ->latest()
            ->first();

        if (!$subscription || !$subscription->isExpired()) {
            $this->error("L'école #{$schoolId} n'a pas d'abonnement expiré");
            return Command::FAILURE;
        }

        if (!$force && !$this->confirm("Êtes-vous sûr de vouloir supprimer toutes les données de l'école #{$schoolId}?")) {
            $this->info('Opération annulée');
            return Command::SUCCESS;
        }

        try {
            DB::beginTransaction();

            // Liste des tables à nettoyer (ajustez selon votre schéma)
            $tables = [
                'sm_students',
                'sm_staffs',
                'sm_parents',
                'sm_classes',
                'sm_sections',
                'sm_subjects',
                'sm_exams',
                'sm_assignments',
                'sm_homeworks',
                'sm_notices',
                'sm_fees',
                'sm_library_books',
                'sm_transports',
                'sm_dormitories',
                // Ajoutez d'autres tables selon vos besoins
            ];

            foreach ($tables as $table) {
                DB::table($table)->where('school_id', $schoolId)->delete();
                $this->info("Données supprimées de la table: {$table}");
            }

            // Supprimer les abonnements et factures
            \Modules\KouffeSaas\Models\SaasInvoice::where('school_id', $schoolId)->delete();
            SaasSubscription::where('school_id', $schoolId)->delete();
            \Modules\KouffeSaas\Models\SaasCustomDomain::where('school_id', $schoolId)->delete();

            DB::commit();

            $this->info("Toutes les données de l'école #{$schoolId} ont été supprimées");
            return Command::SUCCESS;
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error('Erreur lors de la suppression: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}

