<?php

if (!function_exists('kouffe_saas_check_subscription')) {
    /**
     * Vérifie si une école a un abonnement actif
     *
     * @param int $schoolId
     * @return bool
     */
    function kouffe_saas_check_subscription(int $schoolId): bool
    {
        $repo = new \Modules\KouffeSaas\Repositories\InitRepository();
        return $repo->checkSubscription($schoolId);
    }
}

if (!function_exists('kouffe_saas_enforce_limits')) {
    /**
     * Applique les limites d'un plan
     *
     * @param int $schoolId
     * @param string $resourceType
     * @param int $currentCount
     * @return bool
     */
    function kouffe_saas_enforce_limits(int $schoolId, string $resourceType, int $currentCount): bool
    {
        $service = new \Modules\KouffeSaas\Services\SubscriptionService();
        return $service->enforceLimits($schoolId, $resourceType, $currentCount);
    }
}

