@extends('backEnd.master')

@section('title', 'Plans d\'abonnement - Kouffe SaaS')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <h2>Plans d'abonnement</h2>
        </div>
    </div>

    <div class="row">
        @foreach($plans as $plan)
            <div class="col-md-4">
                <div class="card {{ $currentSubscription && $currentSubscription->plan_id === $plan->id ? 'border-primary' : '' }}">
                    <div class="card-header">
                        <h3>{{ $plan->name }}</h3>
                        <h2>{{ number_format($plan->price, 2) }} {{ $plan->currency }}</h2>
                        <small>/ {{ $plan->billing_cycle === 'monthly' ? 'mois' : 'an' }}</small>
                    </div>
                    <div class="card-body">
                        <p>{{ $plan->description }}</p>
                        <ul class="list-unstyled">
                            @if($plan->isUnlimitedStudents())
                                <li>✓ Étudiants illimités</li>
                            @else
                                <li>✓ Jusqu'à {{ $plan->max_students }} étudiants</li>
                            @endif
                            @if($plan->isUnlimitedStorage())
                                <li>✓ Stockage illimité</li>
                            @else
                                <li>✓ {{ $plan->max_storage_gb }} GB de stockage</li>
                            @endif
                            @if($plan->custom_domain)
                                <li>✓ Domaine personnalisé</li>
                            @endif
                            @if($plan->features)
                                @foreach($plan->features as $feature)
                                    <li>✓ {{ $feature }}</li>
                                @endforeach
                            @endif
                        </ul>
                        @if($currentSubscription && $currentSubscription->plan_id === $plan->id)
                            <button class="btn btn-primary" disabled>Plan actuel</button>
                        @else
                            <form action="{{ route('kouffe-saas.school.subscribe') }}" method="POST">
                                @csrf
                                <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                                <button type="submit" class="btn btn-primary">Souscrire</button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection

