<?php

namespace Modules\KouffeSaas\Console\Commands;

use Illuminate\Console\Command;
use Modules\KouffeSaas\Services\SubscriptionService;
use Modules\KouffeSaas\Models\SaasSubscription;

class EnforceLimits extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'kouffe-saas:enforce-limits {--school-id= : ID de l\'école spécifique}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Applique les limites des plans d\'abonnement (étudiants, stockage)';

    protected $subscriptionService;

    public function __construct(SubscriptionService $subscriptionService)
    {
        parent::__construct();
        $this->subscriptionService = $subscriptionService;
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $schoolId = $this->option('school-id');

        if ($schoolId) {
            $this->enforceForSchool((int) $schoolId);
        } else {
            $subscriptions = SaasSubscription::active()->get();
            
            foreach ($subscriptions as $subscription) {
                $this->enforceForSchool($subscription->school_id);
            }
        }

        $this->info('Limites appliquées avec succès');
        return Command::SUCCESS;
    }

    protected function enforceForSchool(int $schoolId)
    {
        $studentCount = \App\Models\Student::where('school_id', $schoolId)->count();
        
        if (!$this->subscriptionService->enforceLimits($schoolId, 'students', $studentCount)) {
            $this->warn("École #{$schoolId}: Limite d'étudiants atteinte");
        }
    }
}

