<?php

namespace Modules\KouffeSaas\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SaasCustomDomain extends Model
{
    use SoftDeletes;

    protected $table = 'saas_custom_domains';

    protected $fillable = [
        'school_id',
        'domain',
        'subdomain',
        'type',
        'is_verified',
        'is_active',
        'verification_token',
        'dns_records',
        'verified_at',
    ];

    protected $casts = [
        'is_verified' => 'boolean',
        'is_active' => 'boolean',
        'dns_records' => 'array',
        'verified_at' => 'datetime',
    ];

    /**
     * Relations
     */
    public function school()
    {
        return $this->belongsTo(\App\Models\SmSchool::class, 'school_id');
    }

    /**
     * Scopes
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true)->where('is_verified', true);
    }

    public function scopeVerified($query)
    {
        return $query->where('is_verified', true);
    }

    /**
     * Generate verification token
     */
    public function generateVerificationToken(): string
    {
        $this->verification_token = bin2hex(random_bytes(32));
        $this->save();
        return $this->verification_token;
    }

    /**
     * Verify domain ownership
     */
    public function verify(): bool
    {
        // Logique de vérification DNS ou fichier
        // Pour l'instant, on simule la vérification
        $this->is_verified = true;
        $this->verified_at = now();
        $this->save();
        return true;
    }
}

