@extends('backEnd.master')

@section('title', 'Configuration du domaine - Kouffe SaaS')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Configuration du domaine</h4>
                </div>
                <div class="card-body">
                    @if($domain)
                        <div class="alert alert-info">
                            <h5>Domaine configuré: {{ $domain->domain }}</h5>
                            <p><strong>Type:</strong> {{ $domain->type === 'subdomain' ? 'Sous-domaine' : 'Domaine personnalisé' }}</p>
                            <p><strong>Statut:</strong> 
                                @if($domain->is_verified && $domain->is_active)
                                    <span class="badge badge-success">Actif</span>
                                @elseif($domain->is_verified)
                                    <span class="badge badge-warning">Vérifié mais inactif</span>
                                @else
                                    <span class="badge badge-danger">Non vérifié</span>
                                @endif
                            </p>
                            @if(!$domain->is_verified)
                                <form action="{{ route('kouffe-saas.school.verify-domain') }}" method="POST" class="mt-3">
                                    @csrf
                                    <input type="hidden" name="domain_id" value="{{ $domain->id }}">
                                    <button type="submit" class="btn btn-primary">Vérifier le domaine</button>
                                </form>
                            @endif
                        </div>
                    @else
                        <form action="{{ route('kouffe-saas.school.setup-domain') }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <label for="domain">Domaine ou sous-domaine</label>
                                <input type="text" class="form-control" id="domain" name="domain" required>
                                <small class="form-text text-muted">
                                    Entrez un sous-domaine (ex: mon-ecole) ou un domaine complet (ex: mon-ecole.com)
                                </small>
                            </div>
                            <div class="form-group">
                                <label for="type">Type</label>
                                <select class="form-control" id="type" name="type" required>
                                    <option value="subdomain">Sous-domaine</option>
                                    <option value="custom">Domaine personnalisé</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Configurer le domaine</button>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

