<?php

use Illuminate\Support\Facades\Route;
use Modules\KouffeSaas\Http\Controllers\SchoolAdminController;
use Modules\KouffeSaas\Middleware\MapSchoolToRequest;

Route::prefix('v1/kouffe-saas')
    ->middleware(['api', 'auth:sanctum', MapSchoolToRequest::class])
    ->group(function () {
        Route::get('/subscription', [SchoolAdminController::class, 'dashboard']);
        Route::get('/plans', [SchoolAdminController::class, 'plans']);
        Route::post('/subscribe', [SchoolAdminController::class, 'subscribe']);
    });

