<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddBehaviourRecordSidebarmenu extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        $behaviour_records = [
            'behaviour_records' => [
                'module' => 'BehaviourRecords',
                'sidebar_menu' => 'behaviour_records',
                'name' => 'Behaviour Records',
                'lang_name' => 'behaviourRecords.behaviour_records',
                'icon' => 'fas fa-clipboard',
                'svg' => null,
                'route' => 'behaviour_records',
                'parent_route' => null,
                'is_admin' => 1,
                'is_teacher' => 0,
                'is_student' => 0,
                'is_parent' => 0,
                'position' => 19,
                'is_saas' => 0,
                'is_menu' => 1,
                'status' => 1,
                'menu_status' => 1,
                'relate_to_child' => 0,
                'alternate_module' => null,
                'permission_section' => 0,
                'user_id' => null,
                'type' => 1,
                'old_id' => null,
                'child' => [
                    'incidents' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Incidents',
                        'lang_name' => 'behaviourRecords.incidents',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.incident',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 1,
                        'is_saas' => 0,
                        'is_menu' => 1,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                        'child' => [
                            'incident_create' => [
                                'module' => null,
                                'sidebar_menu' => null,
                                'name' => 'Add',
                                'lang_name' => null,
                                'icon' => null,
                                'svg' => null,
                                'route' => 'behaviour_records.incident_create',
                                'parent_route' => 'behaviour_records.incident',
                                'is_admin' => 1,
                                'is_teacher' => 0,
                                'is_student' => 0,
                                'is_parent' => 0,
                                'position' => 1,
                                'is_saas' => 0,
                                'is_menu' => 0,
                                'status' => 1,
                                'menu_status' => 1,
                                'relate_to_child' => 0,
                                'alternate_module' => null,
                                'permission_section' => 0,
                                'user_id' => null,
                                'type' => 3,
                                'old_id' => null,
                            ],
                            'incident_update' => [
                                'module' => null,
                                'sidebar_menu' => null,
                                'name' => 'Edit',
                                'lang_name' => null,
                                'icon' => null,
                                'svg' => null,
                                'route' => 'behaviour_records.incident_update',
                                'parent_route' => 'behaviour_records.incident',
                                'is_admin' => 1,
                                'is_teacher' => 0,
                                'is_student' => 0,
                                'is_parent' => 0,
                                'position' => 2,
                                'is_saas' => 0,
                                'is_menu' => 0,
                                'status' => 1,
                                'menu_status' => 1,
                                'relate_to_child' => 0,
                                'alternate_module' => null,
                                'permission_section' => 0,
                                'user_id' => null,
                                'type' => 3,
                                'old_id' => null,
                            ],
                            'incident_delete' => [
                                'module' => null,
                                'sidebar_menu' => null,
                                'name' => 'Delete',
                                'lang_name' => null,
                                'icon' => null,
                                'svg' => null,
                                'route' => 'behaviour_records.incident_delete',
                                'parent_route' => 'behaviour_records.incident',
                                'is_admin' => 1,
                                'is_teacher' => 0,
                                'is_student' => 0,
                                'is_parent' => 0,
                                'position' => 3,
                                'is_saas' => 0,
                                'is_menu' => 0,
                                'status' => 1,
                                'menu_status' => 1,
                                'relate_to_child' => 0,
                                'alternate_module' => null,
                                'permission_section' => 0,
                                'user_id' => null,
                                'type' => 3,
                                'old_id' => null,
                            ],
                        ],
                    ],
                    'assign_incident' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Assign Incident',
                        'lang_name' => 'behaviourRecords.assign_incident',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.assign-incident',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 2,
                        'is_saas' => 0,
                        'is_menu' => 1,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                        'child' => [
                            'assign_incident_save' => [
                                'module' => null,
                                'sidebar_menu' => null,
                                'name' => 'Add',
                                'lang_name' => null,
                                'icon' => null,
                                'svg' => null,
                                'route' => 'behaviour_records.assign_incident_save',
                                'parent_route' => 'behaviour_records.assign-incident',
                                'is_admin' => 1,
                                'is_teacher' => 0,
                                'is_student' => 0,
                                'is_parent' => 0,
                                'position' => 1,
                                'is_saas' => 0,
                                'is_menu' => 0,
                                'status' => 1,
                                'menu_status' => 1,
                                'relate_to_child' => 0,
                                'alternate_module' => null,
                                'permission_section' => 0,
                                'user_id' => null,
                                'type' => 3,
                                'old_id' => null,
                            ],
                            'assign_incident_delete' => [
                                'module' => null,
                                'sidebar_menu' => null,
                                'name' => 'Delete',
                                'lang_name' => null,
                                'icon' => null,
                                'svg' => null,
                                'route' => 'behaviour_records.assign_incident_delete',
                                'parent_route' => 'behaviour_records.assign-incident',
                                'is_admin' => 1,
                                'is_teacher' => 0,
                                'is_student' => 0,
                                'is_parent' => 0,
                                'position' => 2,
                                'is_saas' => 0,
                                'is_menu' => 0,
                                'status' => 1,
                                'menu_status' => 1,
                                'relate_to_child' => 0,
                                'alternate_module' => null,
                                'permission_section' => 0,
                                'user_id' => null,
                                'type' => 3,
                                'old_id' => null,
                            ],
                        ],
                    ],
                    'student_incident_report' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Student Incident Report',
                        'lang_name' => 'behaviourRecords.student_incident_report',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.student_incident_report',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 3,
                        'is_saas' => 0,
                        'is_menu' => 1,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                    ],
                    'student_behaviour_rank_report' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Behaviour Report',
                        'lang_name' => 'behaviourRecords.behaviour_reports',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.student_behaviour_rank_report',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 4,
                        'is_saas' => 0,
                        'is_menu' => 1,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                    ],
                    'class_section_wise_rank_report' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Class Section Report',
                        'lang_name' => 'behaviourRecords.class_section_report',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.class_section_wise_rank_report',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 5,
                        'is_saas' => 0,
                        'is_menu' => 1,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                    ],
                    'incident_wise_report' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Incident Wise Report',
                        'lang_name' => 'behaviourRecords.incident_wise_report',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.incident_wise_report',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 6,
                        'is_saas' => 0,
                        'is_menu' => 1,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                    ],
                    'incident_comment' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Incident Comment',
                        'lang_name' => 'behaviourRecords.incident_comment',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.incident_comment',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 7,
                        'is_saas' => 0,
                        'is_menu' => 0,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                        'child' => [
                            'incident_comment_save' => [
                                'module' => null,
                                'sidebar_menu' => null,
                                'name' => 'Add',
                                'lang_name' => null,
                                'icon' => null,
                                'svg' => null,
                                'route' => 'behaviour_records.incident_comment_save',
                                'parent_route' => 'behaviour_records.incident_comment',
                                'is_admin' => 1,
                                'is_teacher' => 0,
                                'is_student' => 0,
                                'is_parent' => 0,
                                'position' => 1,
                                'is_saas' => 0,
                                'is_menu' => 0,
                                'status' => 1,
                                'menu_status' => 1,
                                'relate_to_child' => 0,
                                'alternate_module' => null,
                                'permission_section' => 0,
                                'user_id' => null,
                                'type' => 3,
                                'old_id' => null,
                            ],
                        ],
                    ],
                    'setting' => [
                        'module' => 'BehaviourRecords',
                        'sidebar_menu' => null,
                        'name' => 'Behaviour Settings',
                        'lang_name' => 'behaviourRecords.behaviour_settings',
                        'icon' => null,
                        'svg' => null,
                        'route' => 'behaviour_records.setting',
                        'parent_route' => 'behaviour_records',
                        'is_admin' => 1,
                        'is_teacher' => 0,
                        'is_student' => 0,
                        'is_parent' => 0,
                        'position' => 8,
                        'is_saas' => 0,
                        'is_menu' => 1,
                        'status' => 1,
                        'menu_status' => 1,
                        'relate_to_child' => 0,
                        'alternate_module' => null,
                        'permission_section' => 0,
                        'user_id' => null,
                        'type' => 2,
                        'old_id' => null,
                    ],
                ],
            ],
        ];
        foreach ($behaviour_records as $behaviour_record) {
            storePermissionData($behaviour_record);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('', function (Blueprint $blueprint): void {});
    }
}
