@extends('backEnd.master')
@section('title')
    @lang('examplan::exp.seat_plan_setting')
@endsection
@section('mainContent')
    <section class="sms-breadcrumb mb-20">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1>@lang('examplan::exp.seat_plan_setting')</h1>

                <div class="bc-pages">
                    <a href="{{ route('dashboard') }}">@lang('common.dashboard')</a>
                    <a href="#">@lang('examplan::exp.exam_plan')</a>
                    <a href="#">@lang('examplan::exp.seat_plan_setting')</a>
                </div>
            </div>
        </div>
    </section>
    <section class="admin-visitor-area up_st_admin_visitor" id="admin-visitor-area">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="white_box_30px">
                                    <!-- SMTP form  -->
                                    <div class="main-title mb-15">
                                        <h3 class="mb-0">@lang('examplan::exp.seat_plan_setting')</h3>
                                    </div>
                                    <form action="{{ route('examplan.seatplan.settingUpdate') }}" method="post" class="bg-white rounded">
                                        @csrf
                                        <div class="row">
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row justify-content-between">
                                                <p class="text-uppercase mb-0">@lang('examplan::exp.school_name') <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="school name will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="school_name" id="school_name_on" value="1" class="common-radio relationButton" @if($setting->school_name) checked @endif>
                                                        <label for="school_name_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="school_name"
                                                                        id="school_name" value="0"
                                                                        class="common-radio relationButton" @if($setting->school_name == 0) checked @endif>
                                                                    <label
                                                                        for="school_name">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row justify-content-between">
                                                <p class="text-uppercase mb-0">@lang('examplan::exp.student_photo') <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="student photo will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="student_photo" id="student_photo_on" value="1" class="common-radio relationButton" @if($setting->student_photo) checked @endif>
                                                        <label for="student_photo_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="student_photo"
                                                                        id="student_photo" value="0"
                                                                        class="common-radio relationButton" @if($setting->student_photo == 0) checked @endif>
                                                                    <label
                                                                        for="student_photo">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row">
                                                <p class="text-uppercase mb-0"> @lang('examplan::exp.student_name') <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="student name will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="student_name"
                                                                        id="student_name_on" value="1"
                                                                        class="common-radio relationButton" @if($setting->student_name) checked @endif>
                                                                    <label
                                                                        for="student_name_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="student_name"
                                                        id="student_name" value="0"
                                                        class="common-radio relationButton" @if($setting->student_name == 0) checked @endif>
                                                    <label
                                                        for="student_name">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row">
                                                <p class="text-uppercase mb-0"> @lang('examplan::exp.admission_no') <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="admission no will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="admission_no"
                                                        id="admission_no_on" value="1"
                                                        class="common-radio relationButton" @if($setting->admission_no) checked @endif>
                                                    <label
                                                        for="admission_no_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="admission_no" id="admission_no" value="0" class="common-radio relationButton" @if($setting->admission_no == 0) checked @endif>
                                                        <label for="admission_no">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row">
                                                <p class="text-uppercase mb-0"> @lang('student.roll_no') <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="roll no will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="roll_no"
                                                        id="roll_no_on" value="1"
                                                        class="common-radio relationButton" @if($setting->roll_no) checked @endif>
                                                    <label
                                                        for="roll_no_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="roll_no" id="roll_no" value="0" class="common-radio relationButton" @if($setting->roll_no == 0) checked @endif>
                                                        <label for="roll_no">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row">
                                                <p class="text-uppercase mb-0"> @if(shiftEnable()) @lang('examplan::exp.class_&_section_&_shift') @else @lang('examplan::exp.class_&_section') @endif <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="class section @if(shiftEnable()) shift @endif will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="class_section"
                                                        id="class_section_on" value="1"
                                                        class="common-radio relationButton" @if($setting->class_section) checked @endif>
                                                    <label
                                                        for="class_section_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="class_section" id="class_section" value="0" class="common-radio relationButton" @if($setting->class_section == 0) checked @endif>
                                                        <label for="class_section">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row">
                                                <p class="text-uppercase mb-0"> @lang('examplan::exp.exam_name') <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="exam name will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="exam_name"
                                                        id="exam_name_on" value="1"
                                                        class="common-radio relationButton" @if($setting->exam_name) checked @endif>
                                                    <label
                                                        for="exam_name_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="exam_name" id="exam_name" value="0" class="common-radio relationButton" @if($setting->exam_name == 0) checked @endif>
                                                        <label for="exam_name">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3 flex-column flex-sm-row">
                                                <p class="text-uppercase mb-0"> @lang('examplan::exp.academic_year') <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="" data-original-title="academic year will show/hide in seat plan"></i></p>
                                                <div class="d-flex radio-btn-flex ml-30 mt-1 gap-20">
                                                    <div >
                                                        <input type="radio" name="academic_year"
                                                        id="academic_year_on" value="1"
                                                        class="common-radio relationButton" @if($setting->academic_year) checked @endif>
                                                    <label
                                                        for="academic_year_on">@lang('examplan::exp.show')</label>
                                                    </div>
                                                    <div >
                                                        <input type="radio" name="academic_year" id="academic_year" value="0" class="common-radio relationButton" @if($setting->academic_year == 0) checked @endif>
                                                        <label for="academic_year">@lang('examplan::exp.hide')</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-20">
                                            <div class="col-lg-12 text-center">
                                                <button class="primary-btn small fix-gr-bg"><i class="ti-check"></i>@lang('common.update')</button>
                                            </div>
                                        </div>   
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
 
