<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('saas_custom_domains', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();
            $table->unsignedInteger('school_id');
            $table->string('domain')->unique();
            $table->string('subdomain')->nullable();
            $table->enum('type', ['subdomain', 'custom'])->default('subdomain');
            $table->boolean('is_verified')->default(false);
            $table->boolean('is_active')->default(false);
            $table->string('verification_token')->nullable();
            $table->text('dns_records')->nullable(); // JSON pour les enregistrements DNS
            $table->dateTime('verified_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('school_id')->references('id')->on('sm_schools')->onDelete('cascade');
            $table->index(['school_id', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('saas_custom_domains');
    }
};

