<?php

namespace Modules\KouffeSaas\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SaasPlan extends Model
{
    use SoftDeletes;

    protected $table = 'saas_plans';

    protected $fillable = [
        'name',
        'slug',
        'description',
        'price',
        'currency',
        'billing_cycle',
        'max_students',
        'max_storage_gb',
        'custom_domain',
        'is_active',
        'trial_days',
        'features',
        'sort_order',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'max_students' => 'integer',
        'max_storage_gb' => 'integer',
        'custom_domain' => 'boolean',
        'is_active' => 'boolean',
        'trial_days' => 'integer',
        'features' => 'array',
        'sort_order' => 'integer',
    ];

    /**
     * Relations
     */
    public function subscriptions()
    {
        return $this->hasMany(SaasSubscription::class, 'plan_id');
    }

    /**
     * Scopes
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('price');
    }

    /**
     * Check if plan allows unlimited students
     */
    public function isUnlimitedStudents(): bool
    {
        return $this->max_students === 0;
    }

    /**
     * Check if plan allows unlimited storage
     */
    public function isUnlimitedStorage(): bool
    {
        return $this->max_storage_gb === 0;
    }
}

