# Module Kouffe SaaS pour InfixEdu

Module SaaS multi-tenant pour l'application Laravel InfixEdu permettant la gestion d'abonnements, de domaines personnalisés et de la multi-location.

## Installation

1. Copier le module dans le répertoire `modules/KouffeSaas`
2. Exécuter les migrations:
```bash
php artisan migrate --path=modules/KouffeSaas/Database/Migrations
```

3. Publier les fichiers de configuration:
```bash
php artisan vendor:publish --tag=kouffesaas-config
```

4. Configurer les variables d'environnement dans `.env`:
```env
KOUFFE_SAAS_BASE_DOMAIN=kouffe.com
KOUFFE_SAAS_WILDCARD_ENABLED=true
KOUFFE_SAAS_TRIAL_DAYS=14
STRIPE_KEY=your_stripe_key
STRIPE_SECRET=your_stripe_secret
PAYPAL_CLIENT_ID=your_paypal_client_id
PAYPAL_CLIENT_SECRET=your_paypal_client_secret
```

5. Activer le module via l'interface d'administration InfixEdu

## Configuration

### Domaines Wildcard

Pour activer les sous-domaines wildcard, configurez votre DNS pour pointer `*.kouffe.com` vers votre serveur.

### Domaines personnalisés

Les écoles avec un plan Premium peuvent configurer leur propre domaine. La vérification se fait via DNS TXT record ou fichier HTML.

## Commandes Artisan

### Vérification quotidienne des abonnements
```bash
php artisan kouffe-saas:check-subscriptions
```

Ajoutez cette commande au cron:
```cron
0 0 * * * cd /path-to-your-project && php artisan kouffe-saas:check-subscriptions
```

### Application des limites
```bash
php artisan kouffe-saas:enforce-limits
php artisan kouffe-saas:enforce-limits --school-id=1
```

### Suppression des données d'une école
```bash
php artisan kouffe-saas:wipe-school {school_id} --force
```

## Structure

- `Models/` - Modèles Eloquent (SaasPlan, SaasSubscription, SaasCustomDomain, SaasInvoice)
- `Repositories/` - Repositories pour la gestion de la licence et de l'installation
- `Services/` - Services métier (SubscriptionService, DomainService, PaymentService)
- `Middleware/` - Middleware pour la détection multi-tenant et l'application des limites
- `Http/Controllers/` - Contrôleurs pour les panels admin et école
- `Console/Commands/` - Commandes Artisan
- `Database/Migrations/` - Migrations de base de données

## Fonctionnalités

### Système d'abonnements
- Plans configurables (Trial, Basic, Premium)
- Limitation de ressources (étudiants, stockage)
- Renouvellement automatique
- Cycle de vie: Pending -> Active -> Expired

### Multi-tenancy
- Détection automatique de l'école via sous-domaine ou domaine personnalisé
- Isolation des données par école
- Middleware de protection

### Domaines personnalisés
- Configuration de sous-domaines wildcard
- Support des domaines personnalisés (plan Premium)
- Vérification DNS automatique

### Paiements
- Intégration Stripe
- Intégration PayPal
- Facturation automatique
- Gestion des factures

### Protection DRM
- Validation de licence via auth.uxseven.com
- Vérification quotidienne
- Blocage automatique en cas d'expiration

## Routes

### Super Admin
- `/admin/kouffe-saas/dashboard` - Tableau de bord
- `/admin/kouffe-saas/institutions` - Liste des institutions
- `/admin/kouffe-saas/plans` - Gestion des plans
- `/admin/kouffe-saas/invoices` - Liste des factures
- `/admin/kouffe-saas/statistics` - Statistiques

### School Admin
- `/school/kouffe-saas/dashboard` - Tableau de bord école
- `/school/kouffe-saas/plans` - Plans disponibles
- `/school/kouffe-saas/domain-settings` - Configuration du domaine
- `/school/kouffe-saas/invoices` - Factures de l'école

## API

### Endpoints API
- `GET /api/v1/kouffe-saas/subscription` - Informations sur l'abonnement
- `GET /api/v1/kouffe-saas/plans` - Liste des plans
- `POST /api/v1/kouffe-saas/subscribe` - Souscrire à un plan

## Sécurité

Le module utilise le système de protection DRM d'InfixEdu:
- Validation de licence via `InitRepository::check()`
- Vérification d'abonnement via `LicenseRepository::checkLicense()`
- Blocage automatique en cas d'expiration

## Support

Pour toute question ou problème, contactez le support à support@kouffe.com

