<?php

use Illuminate\Support\Facades\Route;
use Modules\KouffeSaas\Http\Controllers\SuperAdminController;
use Modules\KouffeSaas\Http\Controllers\SchoolAdminController;
use Modules\KouffeSaas\Http\Controllers\PaymentController;
use Modules\KouffeSaas\Middleware\MapSchoolToRequest;
use Modules\KouffeSaas\Middleware\EnforceSubscriptionLimits;

/*
|--------------------------------------------------------------------------
| Routes Super Admin
|--------------------------------------------------------------------------
*/
Route::prefix('admin/kouffe-saas')->middleware(['auth', 'role:super_admin'])->group(function () {
    Route::get('/dashboard', [SuperAdminController::class, 'dashboard'])->name('kouffe-saas.admin.dashboard');
    Route::get('/institutions', [SuperAdminController::class, 'institutions'])->name('kouffe-saas.admin.institutions');
    Route::get('/plans', [SuperAdminController::class, 'plans'])->name('kouffe-saas.admin.plans');
    Route::post('/plans/store', [SuperAdminController::class, 'storePlan'])->name('kouffe-saas.admin.plans.store');
    Route::get('/invoices', [SuperAdminController::class, 'invoices'])->name('kouffe-saas.admin.invoices');
    Route::get('/statistics', [SuperAdminController::class, 'statistics'])->name('kouffe-saas.admin.statistics');
});

/*
|--------------------------------------------------------------------------
| Routes School Admin
|--------------------------------------------------------------------------
*/
Route::prefix('school/kouffe-saas')
    ->middleware(['auth', 'role:admin', MapSchoolToRequest::class])
    ->group(function () {
        Route::get('/dashboard', [SchoolAdminController::class, 'dashboard'])->name('kouffe-saas.school.dashboard');
        Route::get('/plans', [SchoolAdminController::class, 'plans'])->name('kouffe-saas.school.plans');
        Route::post('/subscribe', [SchoolAdminController::class, 'subscribe'])->name('kouffe-saas.school.subscribe');
        Route::post('/cancel-subscription', [SchoolAdminController::class, 'cancelSubscription'])->name('kouffe-saas.school.cancel-subscription');
        Route::get('/domain-settings', [SchoolAdminController::class, 'domainSettings'])->name('kouffe-saas.school.domain-settings');
        Route::post('/setup-domain', [SchoolAdminController::class, 'setupDomain'])->name('kouffe-saas.school.setup-domain');
        Route::post('/verify-domain', [SchoolAdminController::class, 'verifyDomain'])->name('kouffe-saas.school.verify-domain');
        Route::get('/invoices', [SchoolAdminController::class, 'invoices'])->name('kouffe-saas.school.invoices');
    });

/*
|--------------------------------------------------------------------------
| Routes API Payment
|--------------------------------------------------------------------------
*/
Route::prefix('api/kouffe-saas/payment')->middleware(['auth'])->group(function () {
    Route::post('/stripe', [PaymentController::class, 'processStripePayment'])->name('kouffe-saas.payment.stripe');
    Route::post('/paypal', [PaymentController::class, 'processPayPalPayment'])->name('kouffe-saas.payment.paypal');
    Route::get('/return', [PaymentController::class, 'paymentReturn'])->name('kouffe-saas.payment.return');
});

