<?php

namespace App\Http\Controllers\Admin\SystemSettings;

use App\Http\Controllers\Controller;
use App\Models\MaintenanceSetting;
use App\SmSmsGateway;
use Brian2694\Toastr\Facades\Toastr;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Modules\RolePermission\Entities\InfixRole;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;

class UtilityController extends Controller
{
    public function index()
    {
        if (auth()->user()->school_id == 1) {
            $roles = InfixRole::where('is_saas', 0)->where('id', '!=', 1)->get();
            $setting = MaintenanceSetting::where('school_id', auth()->user()->school_id)->first();

            return view('backEnd.systemSettings.utilityView', ['setting' => $setting, 'roles' => $roles]);
        }

        Toastr::error('Operation Failed', 'Failed');

        return back();
        /*
        try {
            

        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function action($action)
    {

        if (config('app.app_sync')) {
            Toastr::error('Restricted in demo mode');

            return back();
        }
        /*
        try {
        */
        $message = '';
        if ($action == 'optimize_clear') {

            Artisan::call('optimize:clear');

            $message = 'Your System Optimization Successfully Complete';

        } elseif ($action == 'clear_log') {
            file_put_contents(storage_path('logs/laravel.log'), '');

            $message = 'Your System Log File Is Cleared';
        } elseif ($action == 'change_debug') {
            if (env('APP_DEBUG')) {
                envu([
                    'APP_ENV' => 'Production',
                    'APP_DEBUG' => 'false',
                ]);

                $message = 'Debug Mode Disable Successfully ';
            } else {
                envu([
                    'APP_ENV' => 'Production',
                    'APP_DEBUG' => 'true',
                ]);

                $message = 'Debug Mode Enable Successfully';
            }

        } elseif ($action == 'force_https') {
            if (env('FORCE_HTTPS')) {
                envu([
                    'FORCE_HTTPS' => 'false',
                ]);
                $message = 'HTTPS Mode Disable Successfully';
            } else {
                envu([
                    'FORCE_HTTPS' => 'true',
                ]);
                $message = 'HTTPS Mode Enable Successfully ';
            }
        }elseif ($action == 'link_storage') {
            $publicPath = public_path('storage');

            if (!is_link($publicPath)) {
                Artisan::call('storage:link');
                $message = 'Storage link created successfully';
            } else {
                $message = 'Already linked';
            }
        }


        Toastr::success($message, 'Success');

        return redirect()->back();
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function testup(): void
    {
        /*
        try {
        */

        $gateway = SmSmsGateway::where('gateway_name', 'Himalayasms')->first();
        $client = new Client();
        $request = $client->get('https://sms.techhimalaya.com/base/smsapi/index.php', [
            'query' => [
                'key' => $gateway->himalayasms_key,
                'senderid' => $gateway->himalayasms_senderId,
                'campaign' => $gateway->himalayasms_campaign,
                'routeid' => $gateway->himalayasms_routeId,
                'contacts' => '+9779865383233',
                'msg' => 'Hello I am from infixedu, It Is test example sms',
                'type' => 'text',
            ],
            'http_errors' => false,
        ]);

        $response = $request->getBody();
        /*} catch (Exception $exception) {
            Log::info($exception->getMessage());
        }*/
    }

    public function updateMaintenance(Request $request)
    {
        if (config('app.app_sync')) {
            Toastr::error('Restricted in demo mode');

            return back();
        }

        /*        try { */
        if (config('app.app_sync')) {
            Toastr::error('Restricted in demo mode');

            return back();
        }

        $setting = MaintenanceSetting::first();
        $destination = 'public/uploads/settings/';
        if (! $setting) {
            $setting = new MaintenanceSetting();
        }

        $setting->maintenance_mode = $request->maintenance_mode;
        $setting->title = $request->title;
        $setting->sub_title = $request->sub_title;
        $setting->applicable_for = $request->applicable_for ?: [];
        $setting->image = $request->image ? fileUpload($request->image, $destination) : $setting->image;
        $setting->school_id = auth()->user()->school_id;
        $setting->save();
        Toastr::success('Operation Success', 'Success');

        return redirect()->back();
        /*
        } catch (Exception $exception) {
            Log::info($exception->getMessage());
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }
}
