<?php

namespace App\Http\Controllers\Admin\Transport;

use Exception;
use App\SmClass;
use App\SmRoute;
use App\SmStudent;
use App\SmVehicle;
use App\ApiBaseMethod;
use App\SmClassSection;
use Illuminate\Http\Request;
use App\Models\StudentRecord;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Admin\StudentInfo\SmStudentReportController;
use Modules\University\Repositories\Interfaces\UnCommonRepositoryInterface;

class SmTransportController extends Controller
{
    public function studentTransportReport(Request $request)
    {
        /*
        try {
        */
        $classes = SmClass::where('school_id', Auth::user()->school_id)->get();
        $routes = SmRoute::where('school_id', Auth::user()->school_id)->get();
        $vehicles = SmVehicle::status()->get();

        return view('backEnd.transport.student_transport_report', ['classes' => $classes, 'routes' => $routes, 'vehicles' => $vehicles]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function studentTransportReportSearch(Request $request)
    {
        $input = $request->all();
        
        if (moduleStatusCheck('University')) {
            $validator = Validator::make($input, [
                'un_session_id' => 'required',
                'route' => 'required',
                'vehicle' => 'required',
            ]);
        } else {
            $validator = Validator::make($input, [
                'class' => 'required',
                'section' => 'required',
                'route' => 'required',
                'vehicle' => 'required',
            ]);
        }

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        
        /*
        try {
        */
        $student_ids = [];
        $data = [];
        $student_records = StudentRecord::query();
        $classes = SmClass::where('active_status', 1)->where('school_id', Auth::user()->school_id)->get();
        if (moduleStatusCheck('University')) {
            $student_ids = universityFilter($student_records, $request)
                ->distinct('student_id')->get('student_id');
            $stdent_ids = [];
            foreach ($student_ids as $student_id) {
                $stdent_ids[] = $student_id->student_id;
            }
        } else {
            $student_ids = SmStudentReportController::classSectionStudent($request);
        }
        
        $students = SmStudent::where('active_status', 1)
            ->whereHas('studentRecord', function ($query) use ($request): void {
                $query->when($request->class, function ($q) use ($request): void {
                    $q->where('class_id', $request->class);
                });
                $query->when($request->section, function ($q) use ($request): void {
                    $q->where('section_id', $request->section);
                });
                $query->when($request->shift, function ($q) use ($request) {
                    $q->where('shift_id', $request->shift);
                });
            })
            ->when($request->route, function ($q) use ($request): void {
                $q->where('route_list_id', $request->route);
            })
            ->when($request->vehicle, function ($q) use ($request): void {
                $q->where('vechile_id', $request->vehicle);
            })
            //->whereIn('id', $student_ids)
            ->where('school_id', Auth::user()->school_id)
            ->get();
        
        $routes = SmRoute::where('active_status', 1)->where('school_id', Auth::user()->school_id)->get();
        $vehicles = SmVehicle::where('active_status', 1)->where('school_id', Auth::user()->school_id)->get();

        $data['classes'] = $classes;
        $data['sections'] = SmClassSection::where('class_id',$request->class)->with(['sectionName'])->get();
        $data['routes'] = $routes;
        $data['vehicles'] = $vehicles;
        $data['students'] = $students;
        $data['class_id'] = $request->class;
        $data['section_id'] = $request->section;
        $data['shift_id'] = shiftEnable() ? $request->shift : '';
        $data['route_id'] = $request->route;
        $data['vechile_id'] = $request->vehicle;
        if (moduleStatusCheck('University')) {
            $interface = App::make(UnCommonRepositoryInterface::class);
            $data += $interface->getCommonData($request);
        }

        return view('backEnd.transport.student_transport_report', $data);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function studentTransportReportApi(Request $request)
    {

        /*
        try {
        */
        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $transport = DB::table('sm_assign_vehicles')
                ->select('sm_routes.title as route', 'sm_vehicles.vehicle_no', 'sm_vehicles.vehicle_model', 'sm_vehicles.made_year', 'sm_staffs.full_name as driver_name', 'sm_staffs.mobile', 'sm_staffs.driving_license')
                ->join('sm_routes', 'sm_assign_vehicles.route_id', '=', 'sm_routes.id')
                ->join('sm_vehicles', 'sm_assign_vehicles.vehicle_id', '=', 'sm_vehicles.id')
                ->join('sm_staffs', 'sm_vehicles.driver_id', '=', 'sm_staffs.id')
                ->where('school_id', Auth::user()->school_id)->get();

            return ApiBaseMethod::sendResponse($transport, null);
        }
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }
}
