<?php

namespace App\Http\Controllers;

use Modules\RolePermission\Entities\InfixModuleInfo;

class RouteListController extends Controller
{
    public function index(): void
    {

        InfixModuleInfo::where('name', 'like', '%zoom%')->orWhere('route', 'like', '%zoom%')->update(['module_name' => 'Zoom']);
        InfixModuleInfo::where('name', 'like', '%saas%')->orWhere('route', 'like', '%saas%')->update(['module_name' => 'Saas']);
        InfixModuleInfo::where('name', 'like', '%bbb%')
            ->orWhere('route', 'like', '%bbb%')
            ->orWhere('route', 'like', '%bigbluebutton%')
            ->update(['module_name' => 'BBB']);
        InfixModuleInfo::where('name', 'like', '%jitsi%')->orWhere('route', 'like', '%jitsi%')->update(['module_name' => 'Jitsi']);
        InfixModuleInfo::where('name', 'like', '%parentregistration%')->orWhere('route', 'like', '%parentregistration%')->update(['module_name' => 'ParentRegistration']);

        $formatRouteList = $this->routeFormat();
        foreach ($formatRouteList as $key => $list) {
            $va = InfixModuleInfo::updateOrCreate([
                'id' => $key],
                ['name' => $list['name'],
                    'route' => $list['route'],
                    'parent_route' => $list['parent_route'],
                    'type' => $list['type'],
                ]);
        }
    }

    public function update(): void
    {
        //   return $this->adminSection();
        $all = InfixModuleInfo::get();
        $routes = InfixModuleInfo::where('parent_id', 0)->get();
        //foreach ($all as $item) {
            // $parent_route = InfixModuleInfo::where('parent_id', $item->id)->where('parent_id', '!=',0)->update(['parent_route'=>$item->route]);
            // $modifiyList[]=[
            //    'id'=>$item->id,
            //    'type'=>$item->type,
            //    'route'=>$item->route,
            //    'parent_route'=>$parent_route,
            //    'parent_id'=>$item->parent_id
            // ];

        //}

        // return  $modifiyList;
        //   foreach($routes as $item) {
        //           $str = str_replace('&', '', $item->name);
        //           $str = str_replace('  ', ' ', $str);
        //           $str = trim($str);
        //           $name = strtolower(str_replace(' ', '_', $str));
        //           $item->update(['route'=>$name]);
        //   }

        $routes = InfixModuleInfo::get(['id', 'name', 'route', 'parent_route', 'type']);
        $formatRoute = [];
        foreach ($routes as $route) {
            $formatRoute[$route->id] = [
                'name' => $route->name,
                'route' => $route->route,
                'parent_route' => $route->parent_route,
                'type' => $route->type,
            ];
        }

        file_put_contents('route_list_format.php', '<?php  '.var_export($formatRoute, true).';');

    }

    private function adminSection(): void
    {
        $data = [
            [11, 2, 0, '1',  0, 'Admin Section', '', 'admin_section', 'flaticon-analytics', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [12, 2, 11, '2', 0,  'Admission Query', 'admission_query', 'admission_query', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [13, 2, 12, '3', 0,  'Add', '', '', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [14, 2, 12, '3', 0,  'Edit', '', '', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [15, 2, 12, '3', 0,  'Delete', '', '', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],

            [16, 2, 11, '2', 0, 'Visitor Book', 'visitor', 'visitor', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [17, 2, 16, '3', 0, 'Add', '', '', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [18, 2, 16, '3', 0, 'Edit', '', '', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [19, 2, 16, '3', 0, 'Delete', '', '', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
            [20, 2, 16, '3', 0, 'Download', '', '', '', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'],
        ];
        $modifiyList = [];
        foreach ($data as $item) {
            $modifiyList[] = [
                'id' => $item[0],
                'type' => $item[3],
                'route' => $item[6],
            ];

        }

    }

    private function routeFormat()
    {
        return $formatRouteList = [
            1 => [
                'name' => 'Dashboard',
                'route' => 'dashboard',
                'parent_route' => null,
                'type' => 1,
            ],
            2 => [
                'name' => '➡ Number of Student',
                'route' => 'number-of-student',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            3 => [
                'name' => '➡ Number of Teacher',
                'route' => 'number-of-teacher',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            4 => [
                'name' => '➡ Number of Parents',
                'route' => 'number-of-parent',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            5 => [
                'name' => '➡ Number of Staff',
                'route' => 'number-of-staff',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            6 => [
                'name' => '➡ Current Month Income and Expense Chart',
                'route' => 'month-income-expense',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            7 => [
                'name' => '➡ Current Year Income and Expense Chart',
                'route' => 'year-income-expense',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            8 => [
                'name' => '➡ Notice Board',
                'route' => 'notice-board',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            9 => [
                'name' => '➡ Calendar Section',
                'route' => 'calender-section',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            10 => [
                'name' => '➡ To Do list',
                'route' => 'to-do-list',
                'parent_route' => 'dashboard',
                'type' => 3,
            ],
            11 => [
                'name' => 'Admin Section',
                'route' => 'admin_section',
                'parent_route' => null,
                'type' => 1,
            ],
            12 => [
                'name' => 'Admission Query',
                'route' => 'admission_query',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            13 => [
                'name' => 'Add',
                'route' => 'admission_query_store_a',
                'parent_route' => 'admission_query',
                'type' => 3,
            ],
            14 => [
                'name' => 'Edit',
                'route' => 'admission_query_edit',
                'parent_route' => 'admission_query',
                'type' => 3,
            ],
            15 => [
                'name' => 'Delete',
                'route' => 'admission_query_delete',
                'parent_route' => 'admission_query',
                'type' => 3,
            ],
            16 => [
                'name' => 'Visitor Book',
                'route' => 'visitor',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            17 => [
                'name' => 'Add',
                'route' => 'visitor_store',
                'parent_route' => 'visitor',
                'type' => 3,
            ],
            18 => [
                'name' => 'Edit',
                'route' => 'visitor_edit',
                'parent_route' => 'visitor',
                'type' => 3,
            ],
            19 => [
                'name' => 'Delete',
                'route' => 'visitor_delete',
                'parent_route' => 'visitor',
                'type' => 3,
            ],
            20 => [
                'name' => 'Download',
                'route' => 'visitor_download',
                'parent_route' => 'visitor',
                'type' => 3,
            ],
            21 => [
                'name' => 'Complaint',
                'route' => 'complaint',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            22 => [
                'name' => 'Add',
                'route' => 'complaint_store',
                'parent_route' => 'complaint',
                'type' => 3,
            ],
            23 => [
                'name' => 'Edit',
                'route' => 'complaint_edit',
                'parent_route' => 'complaint',
                'type' => 3,
            ],
            24 => [
                'name' => 'Delete',
                'route' => 'complaint_delete',
                'parent_route' => 'complaint',
                'type' => 3,
            ],
            25 => [
                'name' => 'Download',
                'route' => 'download-complaint-document',
                'parent_route' => 'complaint',
                'type' => 3,
            ],
            26 => [
                'name' => 'View',
                'route' => 'complaint_show',
                'parent_route' => 'complaint',
                'type' => 3,
            ],
            27 => [
                'name' => 'Postal Receive',
                'route' => 'postal-receive',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            28 => [
                'name' => 'Add',
                'route' => 'postal-receive-store',
                'parent_route' => 'postal-receive',
                'type' => 3,
            ],
            29 => [
                'name' => 'Edit',
                'route' => 'postal-receive_edit',
                'parent_route' => 'postal-receive',
                'type' => 3,
            ],
            30 => [
                'name' => 'Delete',
                'route' => 'postal-receive_delete',
                'parent_route' => 'postal-receive',
                'type' => 3,
            ],
            31 => [
                'name' => 'Download',
                'route' => 'postal-receive-document',
                'parent_route' => 'postal-receive',
                'type' => 3,
            ],
            32 => [
                'name' => 'Postal Dispatch',
                'route' => 'postal-dispatch',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            33 => [
                'name' => 'Add',
                'route' => 'postal-dispatch-store',
                'parent_route' => 'postal-dispatch',
                'type' => 3,
            ],
            34 => [
                'name' => 'Edit',
                'route' => 'postal-dispatch_edit',
                'parent_route' => 'postal-dispatch',
                'type' => 3,
            ],
            35 => [
                'name' => 'Delete',
                'route' => 'postal-dispatch_delete',
                'parent_route' => 'postal-dispatch',
                'type' => 3,
            ],
            36 => [
                'name' => 'Phone Call Log',
                'route' => 'phone-call',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            37 => [
                'name' => 'Add',
                'route' => 'phone-call-store',
                'parent_route' => 'phone-call',
                'type' => 3,
            ],
            38 => [
                'name' => 'Edit',
                'route' => 'phone-call_edit',
                'parent_route' => 'phone-call',
                'type' => 3,
            ],
            39 => [
                'name' => 'Delete',
                'route' => 'phone-call_delete',
                'parent_route' => 'phone-call',
                'type' => 3,
            ],
            40 => [
                'name' => 'Download',
                'route' => 'postal-dispatch-document',
                'parent_route' => 'postal-dispatch',
                'type' => 3,
            ],
            41 => [
                'name' => 'Admin Setup',
                'route' => 'setup-admin',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            42 => [
                'name' => 'Add',
                'route' => 'setup-admin-store',
                'parent_route' => 'setup-admin',
                'type' => 3,
            ],
            43 => [
                'name' => 'Edit',
                'route' => 'setup-admin-edit',
                'parent_route' => 'setup-admin',
                'type' => 3,
            ],
            44 => [
                'name' => 'Delete',
                'route' => 'setup-admin-delete',
                'parent_route' => 'setup-admin',
                'type' => 3,
            ],
            45 => [
                'name' => 'Student ID Card',
                'route' => 'student-id-card',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            46 => [
                'name' => 'Add',
                'route' => 'create-id-card',
                'parent_route' => 'student-id-card',
                'type' => 3,
            ],
            47 => [
                'name' => 'Edit',
                'route' => 'student-id-card-edit',
                'parent_route' => 'student-id-card',
                'type' => 3,
            ],
            48 => [
                'name' => 'Delete',
                'route' => 'student-id-card-delete',
                'parent_route' => 'student-id-card',
                'type' => 3,
            ],
            49 => [
                'name' => 'Student Certificate',
                'route' => 'student-certificate',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            50 => [
                'name' => 'Add',
                'route' => 'student-certificate-store',
                'parent_route' => 'student-certificate',
                'type' => 3,
            ],
            51 => [
                'name' => 'Edit',
                'route' => 'student-certificate-edit',
                'parent_route' => 'student-certificate',
                'type' => 3,
            ],
            52 => [
                'name' => 'Delete',
                'route' => 'student-certificate-delete',
                'parent_route' => 'student-certificate',
                'type' => 3,
            ],
            53 => [
                'name' => 'Generate Certificate',
                'route' => 'generate_certificate',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            54 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'generate_certificate',
                'type' => 3,
            ],
            55 => [
                'name' => 'Edit',
                'route' => '',
                'parent_route' => 'generate_certificate',
                'type' => 3,
            ],
            56 => [
                'name' => 'Delete',
                'route' => '',
                'parent_route' => 'generate_certificate',
                'type' => 3,
            ],
            57 => [
                'name' => 'Generate ID Card',
                'route' => 'generate_id_card',
                'parent_route' => 'admin_section',
                'type' => 2,
            ],
            58 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'generate_id_card',
                'type' => 3,
            ],
            59 => [
                'name' => 'Edit',
                'route' => '',
                'parent_route' => 'generate_id_card',
                'type' => 3,
            ],
            60 => [
                'name' => 'Delete',
                'route' => '',
                'parent_route' => 'generate_id_card',
                'type' => 3,
            ],
            61 => [
                'name' => 'Student Info',
                'route' => 'student_info',
                'parent_route' => null,
                'type' => 1,
            ],
            62 => [
                'name' => 'Add Student',
                'route' => 'student_admission',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            63 => [
                'name' => 'Import Student',
                'route' => 'import_student',
                'parent_route' => 'student_admission',
                'type' => 3,
            ],
            64 => [
                'name' => 'Student List',
                'route' => 'student_list',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            65 => [
                'name' => 'Add',
                'route' => 'student_store',
                'parent_route' => 'student_list',
                'type' => 3,
            ],
            66 => [
                'name' => 'Edit',
                'route' => 'student_edit',
                'parent_route' => 'student_list',
                'type' => 3,
            ],
            67 => [
                'name' => 'Delete',
                'route' => 'disabled_student',
                'parent_route' => 'student_list',
                'type' => 3,
            ],
            68 => [
                'name' => 'Student Attendance',
                'route' => 'student_attendance',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            69 => [
                'name' => 'Add',
                'route' => 'student-attendance-store',
                'parent_route' => 'student_attendance',
                'type' => 3,
            ],
            70 => [
                'name' => 'Student Attendance Report',
                'route' => 'student_attendance_report',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            71 => [
                'name' => 'Student Category',
                'route' => 'student_category',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            72 => [
                'name' => 'Add',
                'route' => 'student_category_store',
                'parent_route' => 'student_category',
                'type' => 3,
            ],
            73 => [
                'name' => 'Edit',
                'route' => 'student_category_edit',
                'parent_route' => 'student_category',
                'type' => 3,
            ],
            74 => [
                'name' => 'Delete',
                'route' => 'student_category_delete',
                'parent_route' => 'student_category',
                'type' => 3,
            ],
            75 => [
                'name' => 'Download',
                'route' => '',
                'parent_route' => 'student_category',
                'type' => 3,
            ],
            76 => [
                'name' => 'Student Group',
                'route' => 'student_group',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            77 => [
                'name' => 'Add',
                'route' => 'student_group_store',
                'parent_route' => 'student_group',
                'type' => 3,
            ],
            79 => [
                'name' => 'Edit',
                'route' => 'student_group_edit',
                'parent_route' => 'student_group',
                'type' => 3,
            ],
            80 => [
                'name' => 'Delete',
                'route' => 'student_group_delete',
                'parent_route' => 'student_group',
                'type' => 3,
            ],
            81 => [
                'name' => 'Student Promote',
                'route' => 'student_promote',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            82 => [
                'name' => 'Add',
                'route' => 'student-promote-store',
                'parent_route' => 'student_promote',
                'type' => 3,
            ],
            83 => [
                'name' => 'Disabled Students',
                'route' => 'disabled_student',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            84 => [
                'name' => 'Search',
                'route' => 'disabled_student_search',
                'parent_route' => 'disabled_student',
                'type' => 3,
            ],
            85 => [
                'name' => 'Enable',
                'route' => 'enable_student',
                'parent_route' => 'disabled_student',
                'type' => 3,
            ],
            86 => [
                'name' => 'Delete',
                'route' => 'disable_student_delete',
                'parent_route' => 'disabled_student',
                'type' => 3,
            ],
            87 => [
                'name' => 'Study Material',
                'route' => 'study_material',
                'parent_route' => null,
                'type' => 1,
            ],
            88 => [
                'name' => 'Upload Content',
                'route' => 'upload-content',
                'parent_route' => 'study_material',
                'type' => 2,
            ],
            89 => [
                'name' => 'Add',
                'route' => 'save-upload-content',
                'parent_route' => 'upload-content',
                'type' => 3,
            ],
            90 => [
                'name' => 'Download',
                'route' => 'download-content-document',
                'parent_route' => 'upload-content',
                'type' => 3,
            ],
            91 => [
                'name' => 'Delete',
                'route' => 'delete-upload-content',
                'parent_route' => 'upload-content',
                'type' => 3,
            ],
            92 => [
                'name' => 'Assignment',
                'route' => 'assignment-list',
                'parent_route' => 'study_material',
                'type' => 2,
            ],
            93 => [
                'name' => 'Edit',
                'route' => 'assignment-list-edit',
                'parent_route' => 'assignment-list',
                'type' => 3,
            ],
            94 => [
                'name' => 'Download',
                'route' => 'assignment-list-download',
                'parent_route' => 'assignment-list',
                'type' => 3,
            ],
            95 => [
                'name' => 'Delete',
                'route' => 'assignment-list-delete',
                'parent_route' => 'assignment-list',
                'type' => 3,
            ],
            100 => [
                'name' => 'Syllabus',
                'route' => 'syllabus-list',
                'parent_route' => 'study_material',
                'type' => 2,
            ],
            101 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'syllabus-list',
                'type' => 3,
            ],
            102 => [
                'name' => 'Edit',
                'route' => 'syllabus-list-edit',
                'parent_route' => 'syllabus-list',
                'type' => 3,
            ],
            103 => [
                'name' => 'Delete',
                'route' => 'syllabus-list-delete',
                'parent_route' => 'syllabus-list',
                'type' => 3,
            ],
            104 => [
                'name' => 'Download',
                'route' => 'syllabus-list-download',
                'parent_route' => 'syllabus-list',
                'type' => 3,
            ],
            105 => [
                'name' => 'Other Downloads',
                'route' => 'other-download-list',
                'parent_route' => 'study_material',
                'type' => 2,
            ],
            106 => [
                'name' => 'Download',
                'route' => 'other-download-list-download',
                'parent_route' => 'other-download-list',
                'type' => 3,
            ],
            107 => [
                'name' => 'Delete',
                'route' => 'other-download-list-delete',
                'parent_route' => 'other-download-list',
                'type' => 3,
            ],
            108 => [
                'name' => 'Fees Collection',
                'route' => 'fees_collection',
                'parent_route' => null,
                'type' => 1,
            ],
            109 => [
                'name' => 'Collect Fees',
                'route' => 'collect_fees',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            110 => [
                'name' => ' Collect Fees',
                'route' => 'fees_collect_student_wise',
                'parent_route' => 'collect_fees',
                'type' => 3,
            ],
            111 => [
                'name' => 'Add',
                'route' => 'fees-generate-modal',
                'parent_route' => 'collect_fees',
                'type' => 3,
            ],
            112 => [
                'name' => 'Print',
                'route' => 'fees_payment_print',
                'parent_route' => 'collect_fees',
                'type' => 3,
            ],
            113 => [
                'name' => 'Search Fees Payment',
                'route' => 'search_fees_payment',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            114 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'search_fees_payment',
                'type' => 3,
            ],
            115 => [
                'name' => 'edit',
                'route' => 'edit-fees-payment',
                'parent_route' => 'search_fees_payment',
                'type' => 3,
            ],
            116 => [
                'name' => 'Search Fees Due',
                'route' => 'search_fees_due',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            117 => [
                'name' => 'View',
                'route' => '',
                'parent_route' => 'search_fees_due',
                'type' => 3,
            ],
            118 => [
                'name' => 'Fees Master',
                'route' => 'fees-master',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            119 => [
                'name' => 'Add',
                'route' => 'fees-master-store',
                'parent_route' => 'fees-master',
                'type' => 3,
            ],
            120 => [
                'name' => 'Edit',
                'route' => 'fees-master-edit',
                'parent_route' => 'fees-master',
                'type' => 3,
            ],
            121 => [
                'name' => 'Delete',
                'route' => 'fees-master-delete',
                'parent_route' => 'fees-master',
                'type' => 3,
            ],
            122 => [
                'name' => 'Assign',
                'route' => 'fees_assign',
                'parent_route' => 'fees-master',
                'type' => 3,
            ],
            123 => [
                'name' => 'Fees Group',
                'route' => 'fees_group',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            124 => [
                'name' => 'Add',
                'route' => 'fees_group_store',
                'parent_route' => 'fees_group',
                'type' => 3,
            ],
            125 => [
                'name' => 'Edit',
                'route' => 'fees_group_edit',
                'parent_route' => 'fees_group',
                'type' => 3,
            ],
            126 => [
                'name' => 'Delete',
                'route' => 'fees_group_delete',
                'parent_route' => 'fees_group',
                'type' => 3,
            ],
            127 => [
                'name' => 'Fees Type',
                'route' => 'fees_type',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            128 => [
                'name' => 'Add',
                'route' => 'fees_type_store',
                'parent_route' => 'fees_type',
                'type' => 3,
            ],
            129 => [
                'name' => 'Edit',
                'route' => 'fees_type_edit',
                'parent_route' => 'fees_type',
                'type' => 3,
            ],
            130 => [
                'name' => 'Delete',
                'route' => 'fees_type_delete',
                'parent_route' => 'fees_type',
                'type' => 3,
            ],
            131 => [
                'name' => 'Fees Discount',
                'route' => 'fees_discount',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            132 => [
                'name' => 'Add',
                'route' => 'fees_discount_store',
                'parent_route' => 'fees_discount',
                'type' => 3,
            ],
            133 => [
                'name' => 'Edit',
                'route' => 'fees_discount_edit',
                'parent_route' => 'fees_discount',
                'type' => 3,
            ],
            134 => [
                'name' => 'Delete',
                'route' => 'fees_discount_delete',
                'parent_route' => 'fees_discount',
                'type' => 3,
            ],
            135 => [
                'name' => 'Assign',
                'route' => 'fees_discount_assign',
                'parent_route' => 'fees_discount',
                'type' => 3,
            ],
            136 => [
                'name' => 'Fees Carry Forward',
                'route' => 'fees_forward',
                'parent_route' => 'fees_collection',
                'type' => 3,
            ],
            137 => [
                'name' => 'Accounts',
                'route' => 'accounts',
                'parent_route' => null,
                'type' => 1,
            ],
            138 => [
                'name' => 'Profit & Loss',
                'route' => 'profit',
                'parent_route' => 'accounts',
                'type' => 2,
            ],
            139 => [
                'name' => 'Income',
                'route' => 'add_income',
                'parent_route' => 'accounts',
                'type' => 2,
            ],
            140 => [
                'name' => 'Add',
                'route' => 'add_income_store',
                'parent_route' => 'add_income',
                'type' => 3,
            ],
            141 => [
                'name' => 'Edit',
                'route' => 'add_income_edit',
                'parent_route' => 'add_income',
                'type' => 3,
            ],
            142 => [
                'name' => 'Delete',
                'route' => 'add_income_delete',
                'parent_route' => 'add_income',
                'type' => 3,
            ],
            143 => [
                'name' => 'Expense',
                'route' => 'add-expense',
                'parent_route' => 'accounts',
                'type' => 2,
            ],
            144 => [
                'name' => 'Add',
                'route' => 'add-expense-store',
                'parent_route' => 'add-expense',
                'type' => 3,
            ],
            145 => [
                'name' => 'Edit',
                'route' => 'add-expense-edit',
                'parent_route' => 'add-expense',
                'type' => 3,
            ],
            146 => [
                'name' => 'Delete',
                'route' => 'add-expense-delete',
                'parent_route' => 'add-expense',
                'type' => 3,
            ],
            148 => [
                'name' => 'Chart of Account',
                'route' => 'chart-of-account',
                'parent_route' => 'accounts',
                'type' => 2,
            ],
            149 => [
                'name' => 'Add',
                'route' => 'chart-of-account-store',
                'parent_route' => 'chart-of-account',
                'type' => 3,
            ],
            150 => [
                'name' => 'Edit',
                'route' => 'chart-of-account-edit',
                'parent_route' => 'chart-of-account',
                'type' => 3,
            ],
            151 => [
                'name' => 'Delete',
                'route' => 'chart-of-account-delete',
                'parent_route' => 'chart-of-account',
                'type' => 3,
            ],
            153 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'payment-method-settings',
                'type' => 3,
            ],
            154 => [
                'name' => 'Edit',
                'route' => '',
                'parent_route' => 'payment-method-settings',
                'type' => 3,
            ],
            155 => [
                'name' => 'Delete',
                'route' => '',
                'parent_route' => 'payment-method-settings',
                'type' => 3,
            ],
            156 => [
                'name' => 'Bank Account',
                'route' => 'bank-account',
                'parent_route' => 'accounts',
                'type' => 2,
            ],
            157 => [
                'name' => 'Add',
                'route' => 'bank-account-store',
                'parent_route' => 'bank-account',
                'type' => 3,
            ],
            158 => [
                'name' => 'Bank Transaction',
                'route' => 'bank-transaction',
                'parent_route' => 'bank-account',
                'type' => 3,
            ],
            159 => [
                'name' => 'Delete',
                'route' => 'bank-account-delete',
                'parent_route' => 'bank-account',
                'type' => 3,
            ],
            160 => [
                'name' => 'Human Resource',
                'route' => 'human_resource',
                'parent_route' => null,
                'type' => 1,
            ],
            161 => [
                'name' => 'Staff Directory',
                'route' => 'staff_directory',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            162 => [
                'name' => 'Add',
                'route' => 'addStaff',
                'parent_route' => 'staff_directory',
                'type' => 3,
            ],
            163 => [
                'name' => 'Edit',
                'route' => 'editStaff',
                'parent_route' => 'staff_directory',
                'type' => 3,
            ],
            164 => [
                'name' => 'Delete',
                'route' => 'deleteStaff',
                'parent_route' => 'staff_directory',
                'type' => 3,
            ],
            165 => [
                'name' => 'Staff Attendance',
                'route' => 'staff_attendance',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            166 => [
                'name' => 'Add',
                'route' => 'staff-attendance-store',
                'parent_route' => 'staff_attendance',
                'type' => 3,
            ],
            167 => [
                'name' => 'Edit',
                'route' => '',
                'parent_route' => 'staff_attendance',
                'type' => 3,
            ],
            168 => [
                'name' => 'Delete',
                'route' => '',
                'parent_route' => 'staff_attendance',
                'type' => 3,
            ],
            169 => [
                'name' => 'Staff Attendance Report',
                'route' => 'staff_attendance_report',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            170 => [
                'name' => 'Payroll',
                'route' => 'payroll',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            171 => [
                'name' => 'Edit',
                'route' => '',
                'parent_route' => 'payroll',
                'type' => 3,
            ],
            172 => [
                'name' => 'Delete',
                'route' => '',
                'parent_route' => 'payroll',
                'type' => 3,
            ],
            173 => [
                'name' => 'Search',
                'route' => 'payroll-search',
                'parent_route' => 'payroll',
                'type' => 3,
            ],
            174 => [
                'name' => 'Generate Payroll',
                'route' => 'generate-Payroll',
                'parent_route' => 'payroll',
                'type' => 3,
            ],
            175 => [
                'name' => 'Create',
                'route' => 'savePayrollData',
                'parent_route' => 'payroll',
                'type' => 3,
            ],
            176 => [
                'name' => 'Proceed To Pay',
                'route' => 'pay-payroll',
                'parent_route' => 'payroll',
                'type' => 3,
            ],
            177 => [
                'name' => 'View Payslip',
                'route' => 'view-payslip',
                'parent_route' => 'payroll',
                'type' => 3,
            ],
            178 => [
                'name' => 'Payroll Report',
                'route' => 'payroll-report',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            179 => [
                'name' => 'Report Search',
                'route' => '',
                'parent_route' => 'payroll-report',
                'type' => 3,
            ],
            180 => [
                'name' => 'Designation',
                'route' => 'designation',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            181 => [
                'name' => 'Add',
                'route' => 'designation-store',
                'parent_route' => 'designation',
                'type' => 3,
            ],
            182 => [
                'name' => 'Edit',
                'route' => 'designation-edit',
                'parent_route' => 'designation',
                'type' => 3,
            ],
            183 => [
                'name' => 'Delete',
                'route' => 'designation-delete',
                'parent_route' => 'designation',
                'type' => 3,
            ],
            184 => [
                'name' => 'Department',
                'route' => 'department',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            185 => [
                'name' => 'Add',
                'route' => 'department-store',
                'parent_route' => 'department',
                'type' => 3,
            ],
            186 => [
                'name' => 'Edit',
                'route' => 'department-edit',
                'parent_route' => 'department',
                'type' => 3,
            ],
            187 => [
                'name' => 'Delete',
                'route' => 'department-delete',
                'parent_route' => 'department',
                'type' => 3,
            ],
            188 => [
                'name' => 'Leave',
                'route' => 'leave',
                'parent_route' => null,
                'type' => 1,
            ],
            189 => [
                'name' => 'Approve Leave Request',
                'route' => 'approve-leave',
                'parent_route' => 'leave',
                'type' => 2,
            ],
            190 => [
                'name' => 'Add',
                'route' => 'approve-leave-store',
                'parent_route' => 'approve-leave',
                'type' => 3,
            ],
            191 => [
                'name' => 'Edit',
                'route' => 'approve-leave-edit',
                'parent_route' => 'approve-leave',
                'type' => 3,
            ],
            192 => [
                'name' => 'Delete',
                'route' => 'approve-leave-delete',
                'parent_route' => 'approve-leave',
                'type' => 3,
            ],
            193 => [
                'name' => 'Apply Leave',
                'route' => 'apply-leave',
                'parent_route' => 'leave',
                'type' => 2,
            ],
            194 => [
                'name' => 'View',
                'route' => 'view-leave-details-apply',
                'parent_route' => 'apply-leave',
                'type' => 3,
            ],
            195 => [
                'name' => 'Delete',
                'route' => 'apply-leave-delete',
                'parent_route' => 'apply-leave',
                'type' => 3,
            ],
            196 => [
                'name' => 'Pending Leave',
                'route' => 'pending-leave',
                'parent_route' => 'leave',
                'type' => 2,
            ],
            197 => [
                'name' => 'View',
                'route' => 'view-leave-details-approve',
                'parent_route' => 'pending-leave',
                'type' => 3,
            ],
            198 => [
                'name' => 'Delete',
                'route' => 'apply-leave-delete',
                'parent_route' => 'pending-leave',
                'type' => 3,
            ],
            199 => [
                'name' => 'Leave Define',
                'route' => 'leave-define',
                'parent_route' => 'leave',
                'type' => 2,
            ],
            200 => [
                'name' => 'Add',
                'route' => 'leave-define-store',
                'parent_route' => 'leave-define',
                'type' => 3,
            ],
            201 => [
                'name' => 'Edit',
                'route' => 'leave-define-edit',
                'parent_route' => 'leave-define',
                'type' => 3,
            ],
            202 => [
                'name' => 'Delete',
                'route' => 'leave-define-delete',
                'parent_route' => 'leave-define',
                'type' => 3,
            ],
            203 => [
                'name' => 'Leave Type',
                'route' => 'leave-type',
                'parent_route' => 'leave',
                'type' => 2,
            ],
            204 => [
                'name' => 'Add',
                'route' => 'leave-type-store',
                'parent_route' => 'leave-type',
                'type' => 3,
            ],
            205 => [
                'name' => 'Edit',
                'route' => 'leave-type-edit',
                'parent_route' => 'leave-type',
                'type' => 3,
            ],
            206 => [
                'name' => 'Delete',
                'route' => 'leave-type-delete',
                'parent_route' => 'leave-type',
                'type' => 3,
            ],
            207 => [
                'name' => 'Examination',
                'route' => 'examination',
                'parent_route' => null,
                'type' => 1,
            ],
            208 => [
                'name' => 'Exam Type',
                'route' => 'exam-type',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            209 => [
                'name' => 'Add',
                'route' => 'exam_type_store',
                'parent_route' => 'exam-type',
                'type' => 3,
            ],
            210 => [
                'name' => 'Edit',
                'route' => 'exam_type_edit',
                'parent_route' => 'exam-type',
                'type' => 3,
            ],
            211 => [
                'name' => 'Delete',
                'route' => 'exam_type_delete',
                'parent_route' => 'exam-type',
                'type' => 3,
            ],
            214 => [
                'name' => 'Exam Setup',
                'route' => 'exam',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            215 => [
                'name' => 'Add',
                'route' => 'exam-setup-store',
                'parent_route' => 'exam',
                'type' => 3,
            ],
            216 => [
                'name' => 'Delete',
                'route' => 'exam-delete',
                'parent_route' => 'exam',
                'type' => 3,
            ],
            217 => [
                'name' => 'Exam Schedule',
                'route' => 'exam_schedule',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            218 => [
                'name' => 'Add',
                'route' => 'exam_schedule_store',
                'parent_route' => 'exam_schedule',
                'type' => 3,
            ],
            219 => [
                'name' => 'print',
                'route' => 'exam-routine-print',
                'parent_route' => 'exam_schedule',
                'type' => 3,
            ],
            220 => [
                'name' => 'Exam Attendance',
                'route' => 'exam_attendance',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            221 => [
                'name' => 'Add',
                'route' => 'exam_attendance_create',
                'parent_route' => 'exam_attendance',
                'type' => 3,
            ],
            222 => [
                'name' => 'Marks Register',
                'route' => 'marks_register',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            223 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'marks_register',
                'type' => 3,
            ],
            224 => [
                'name' => 'Create',
                'route' => 'marks_register_create',
                'parent_route' => 'marks_register',
                'type' => 3,
            ],
            225 => [
                'name' => 'Marks Grade',
                'route' => 'marks-grade',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            226 => [
                'name' => 'Add',
                'route' => 'marks-grade-store',
                'parent_route' => 'marks-grade',
                'type' => 3,
            ],
            227 => [
                'name' => 'Edit',
                'route' => 'marks-grade-edit',
                'parent_route' => 'marks-grade',
                'type' => 3,
            ],
            228 => [
                'name' => 'Delete',
                'route' => 'marks-grade-delete',
                'parent_route' => 'marks-grade',
                'type' => 3,
            ],
            229 => [
                'name' => 'Send Marks By SMS',
                'route' => 'send_marks_by_sms',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            230 => [
                'name' => 'Question Group',
                'route' => 'question-group',
                'parent_route' => 'online_exam',
                'type' => 2,
            ],
            231 => [
                'name' => 'Add',
                'route' => 'question-group-store',
                'parent_route' => 'question-group',
                'type' => 3,
            ],
            232 => [
                'name' => 'Edit',
                'route' => 'question-group-edit',
                'parent_route' => 'question-group',
                'type' => 3,
            ],
            233 => [
                'name' => 'Delete',
                'route' => 'question-group-delete',
                'parent_route' => 'question-group',
                'type' => 3,
            ],
            234 => [
                'name' => 'Question Bank',
                'route' => 'question-bank',
                'parent_route' => 'online_exam',
                'type' => 2,
            ],
            235 => [
                'name' => 'Add',
                'route' => 'question-bank-store',
                'parent_route' => 'question-bank',
                'type' => 3,
            ],
            236 => [
                'name' => 'Edit',
                'route' => 'question-bank-edit',
                'parent_route' => 'question-bank',
                'type' => 3,
            ],
            237 => [
                'name' => 'Delete',
                'route' => 'question-bank-delete',
                'parent_route' => 'question-bank',
                'type' => 3,
            ],
            238 => [
                'name' => 'Online Exam',
                'route' => 'online-exam',
                'parent_route' => 'online_exam',
                'type' => 2,
            ],
            239 => [
                'name' => 'Add',
                'route' => 'online-exam-store',
                'parent_route' => 'online-exam',
                'type' => 3,
            ],
            240 => [
                'name' => 'Edit',
                'route' => 'online-exam-edit',
                'parent_route' => 'online-exam',
                'type' => 3,
            ],
            241 => [
                'name' => 'Delete',
                'route' => 'online-exam-delete',
                'parent_route' => 'online-exam',
                'type' => 3,
            ],
            242 => [
                'name' => 'Manage Question',
                'route' => 'manage_online_exam_question',
                'parent_route' => 'online-exam',
                'type' => 3,
            ],
            243 => [
                'name' => 'Marks Register',
                'route' => 'online_exam_marks_register',
                'parent_route' => 'online-exam',
                'type' => 3,
            ],
            244 => [
                'name' => 'Result',
                'route' => 'online_exam_result',
                'parent_route' => 'online-exam',
                'type' => 3,
            ],
            245 => [
                'name' => 'Academics',
                'route' => 'academics',
                'parent_route' => null,
                'type' => 1,
            ],
            246 => [
                'name' => 'Class Routine',
                'route' => 'class_routine_new',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            247 => [
                'name' => 'Add',
                'route' => 'add-new-class-routine-store',
                'parent_route' => 'class_routine_new',
                'type' => 3,
            ],
            248 => [
                'name' => 'Print',
                'route' => 'classRoutinePrint',
                'parent_route' => 'class_routine_new',
                'type' => 3,
            ],
            249 => [
                'name' => 'Delete',
                'route' => 'delete-class-routine',
                'parent_route' => 'class_routine_new',
                'type' => 3,
            ],
            250 => [
                'name' => 'Assign Subject',
                'route' => 'assign_subject',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            251 => [
                'name' => 'Add',
                'route' => 'assign-subject-store',
                'parent_route' => 'assign_subject',
                'type' => 3,
            ],
            252 => [
                'name' => 'view',
                'route' => 'assign_subject_create',
                'parent_route' => 'assign_subject',
                'type' => 3,
            ],
            253 => [
                'name' => 'Assign Class Teacher',
                'route' => 'assign-class-teacher',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            254 => [
                'name' => 'Add',
                'route' => 'assign-class-teacher-store',
                'parent_route' => 'assign-class-teacher',
                'type' => 3,
            ],
            255 => [
                'name' => 'Edit',
                'route' => 'assign-class-teacher-edit',
                'parent_route' => 'assign-class-teacher',
                'type' => 3,
            ],
            256 => [
                'name' => 'Delete',
                'route' => 'assign-class-teacher-delete',
                'parent_route' => 'assign-class-teacher',
                'type' => 3,
            ],
            257 => [
                'name' => 'Subjects',
                'route' => 'subject',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            258 => [
                'name' => 'Add',
                'route' => 'subject_store',
                'parent_route' => 'subject',
                'type' => 3,
            ],
            259 => [
                'name' => 'Edit',
                'route' => 'subject_edit',
                'parent_route' => 'subject',
                'type' => 3,
            ],
            260 => [
                'name' => 'Delete',
                'route' => 'subject_delete',
                'parent_route' => 'subject',
                'type' => 3,
            ],
            261 => [
                'name' => 'Class',
                'route' => 'class',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            262 => [
                'name' => 'Add',
                'route' => 'class_store',
                'parent_route' => 'class',
                'type' => 3,
            ],
            263 => [
                'name' => 'Edit',
                'route' => 'class_edit',
                'parent_route' => 'class',
                'type' => 3,
            ],
            264 => [
                'name' => 'Delete',
                'route' => 'class_delete',
                'parent_route' => 'class',
                'type' => 3,
            ],
            265 => [
                'name' => 'Section',
                'route' => 'section',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            266 => [
                'name' => 'Add',
                'route' => 'section_store',
                'parent_route' => 'section',
                'type' => 3,
            ],
            267 => [
                'name' => 'Edit',
                'route' => 'section_edit',
                'parent_route' => 'section',
                'type' => 3,
            ],
            268 => [
                'name' => 'Delete',
                'route' => 'section_delete',
                'parent_route' => 'section',
                'type' => 3,
            ],
            269 => [
                'name' => 'Class Room',
                'route' => 'class-room',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            270 => [
                'name' => 'Add',
                'route' => 'class-room-store',
                'parent_route' => 'class-room',
                'type' => 3,
            ],
            271 => [
                'name' => 'Edit',
                'route' => 'class-room-edit',
                'parent_route' => 'class-room',
                'type' => 3,
            ],
            272 => [
                'name' => 'Delete',
                'route' => 'class-room-delete',
                'parent_route' => 'class-room',
                'type' => 3,
            ],
            273 => [
                'name' => 'Class Time Setup',
                'route' => 'class-time',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            274 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'class-time',
                'type' => 3,
            ],
            275 => [
                'name' => 'Edit',
                'route' => '',
                'parent_route' => 'class-time',
                'type' => 3,
            ],
            276 => [
                'name' => 'Delete',
                'route' => '',
                'parent_route' => 'class-time',
                'type' => 3,
            ],
            277 => [
                'name' => 'Homework',
                'route' => 'homework',
                'parent_route' => null,
                'type' => 1,
            ],
            278 => [
                'name' => 'Add Homework',
                'route' => 'add-homeworks',
                'parent_route' => 'homework',
                'type' => 2,
            ],
            279 => [
                'name' => 'Add',
                'route' => 'saveHomeworkData',
                'parent_route' => 'add-homeworks',
                'type' => 3,
            ],
            280 => [
                'name' => 'Homework List',
                'route' => 'homework-list',
                'parent_route' => 'homework',
                'type' => 2,
            ],
            281 => [
                'name' => 'Evaluation',
                'route' => 'evaluation-homework',
                'parent_route' => 'homework-list',
                'type' => 3,
            ],
            282 => [
                'name' => 'Edit',
                'route' => 'homework_edit',
                'parent_route' => 'homework-list',
                'type' => 3,
            ],
            283 => [
                'name' => 'Delete',
                'route' => 'homework_delete',
                'parent_route' => 'homework-list',
                'type' => 3,
            ],
            284 => [
                'name' => 'Homework Evaluation Report',
                'route' => 'evaluation-report',
                'parent_route' => 'homework',
                'type' => 2,
            ],
            285 => [
                'name' => 'View',
                'route' => 'view-evaluation-report',
                'parent_route' => 'evaluation-report',
                'type' => 3,
            ],
            286 => [
                'name' => 'Communicate',
                'route' => 'communicate',
                'parent_route' => null,
                'type' => 1,
            ],
            287 => [
                'name' => 'Notice Board',
                'route' => 'notice-list',
                'parent_route' => 'communicate',
                'type' => 2,
            ],
            288 => [
                'name' => 'Add',
                'route' => 'add-notice',
                'parent_route' => 'notice-list',
                'type' => 3,
            ],
            289 => [
                'name' => 'Edit',
                'route' => 'edit-notice',
                'parent_route' => 'notice-list',
                'type' => 3,
            ],
            290 => [
                'name' => 'Delete',
                'route' => 'delete-notice-view',
                'parent_route' => 'notice-list',
                'type' => 3,
            ],
            291 => [
                'name' => 'Send Email / SMS ',
                'route' => 'send-email-sms-view',
                'parent_route' => 'communicate',
                'type' => 2,
            ],
            292 => [
                'name' => 'Send',
                'route' => 'send-email-sms',
                'parent_route' => 'send-email-sms-view',
                'type' => 3,
            ],
            293 => [
                'name' => 'Email / SMS Log',
                'route' => 'email-sms-log',
                'parent_route' => 'communicate',
                'type' => 2,
            ],
            294 => [
                'name' => 'Event',
                'route' => 'event',
                'parent_route' => 'communicate',
                'type' => 2,
            ],
            295 => [
                'name' => 'Add',
                'route' => 'event-store',
                'parent_route' => 'event',
                'type' => 3,
            ],
            296 => [
                'name' => 'Edit',
                'route' => 'event-edit',
                'parent_route' => 'event',
                'type' => 3,
            ],
            297 => [
                'name' => 'Delete',
                'route' => 'delete-event-view',
                'parent_route' => 'event',
                'type' => 3,
            ],
            298 => [
                'name' => 'Library',
                'route' => 'library',
                'parent_route' => null,
                'type' => 1,
            ],
            299 => [
                'name' => 'Add Book',
                'route' => 'add-book',
                'parent_route' => 'library',
                'type' => 2,
            ],
            300 => [
                'name' => 'Add',
                'route' => 'save-book-data',
                'parent_route' => 'add-book',
                'type' => 3,
            ],
            301 => [
                'name' => 'Book List ',
                'route' => 'book-list',
                'parent_route' => 'library',
                'type' => 2,
            ],
            302 => [
                'name' => 'Edit',
                'route' => 'edit-book',
                'parent_route' => 'book-list',
                'type' => 3,
            ],
            303 => [
                'name' => 'Delete',
                'route' => 'delete-book-view',
                'parent_route' => 'book-list',
                'type' => 3,
            ],
            304 => [
                'name' => 'Book Categories',
                'route' => 'book-category-list',
                'parent_route' => 'library',
                'type' => 2,
            ],
            305 => [
                'name' => 'Add',
                'route' => 'book-category-list-store',
                'parent_route' => 'book-category-list',
                'type' => 3,
            ],
            306 => [
                'name' => 'Edit',
                'route' => 'book-category-list-edit',
                'parent_route' => 'book-category-list',
                'type' => 3,
            ],
            307 => [
                'name' => 'Delete',
                'route' => 'book-category-list-delete',
                'parent_route' => 'book-category-list',
                'type' => 3,
            ],
            308 => [
                'name' => 'Add Member',
                'route' => 'library-member',
                'parent_route' => 'library',
                'type' => 2,
            ],
            309 => [
                'name' => 'Add',
                'route' => 'library-member-store',
                'parent_route' => 'library-member',
                'type' => 3,
            ],
            310 => [
                'name' => 'Cancel',
                'route' => 'cancel-membership',
                'parent_route' => 'library-member',
                'type' => 3,
            ],
            311 => [
                'name' => 'Issue/Return Book',
                'route' => 'member-list',
                'parent_route' => 'library',
                'type' => 2,
            ],
            312 => [
                'name' => 'Issue',
                'route' => 'issue-books',
                'parent_route' => 'member-list',
                'type' => 3,
            ],
            313 => [
                'name' => 'Return',
                'route' => 'return-book-view',
                'parent_route' => 'member-list',
                'type' => 3,
            ],
            314 => [
                'name' => 'All Issued Book',
                'route' => 'all-issed-book',
                'parent_route' => 'library',
                'type' => 2,
            ],
            315 => [
                'name' => 'Inventory',
                'route' => 'inventory',
                'parent_route' => null,
                'type' => 1,
            ],
            316 => [
                'name' => 'Item Category',
                'route' => 'item-category',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            317 => [
                'name' => 'Add',
                'route' => 'item-category-store',
                'parent_route' => 'item-category',
                'type' => 3,
            ],
            318 => [
                'name' => 'Edit',
                'route' => 'item-category-edit',
                'parent_route' => 'item-category',
                'type' => 3,
            ],
            319 => [
                'name' => 'Delete',
                'route' => 'delete-item-category-view',
                'parent_route' => 'item-category',
                'type' => 3,
            ],
            320 => [
                'name' => 'Item List',
                'route' => 'item-list',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            321 => [
                'name' => 'Add',
                'route' => 'item-list-store',
                'parent_route' => 'item-list',
                'type' => 3,
            ],
            322 => [
                'name' => 'Edit',
                'route' => 'item-list-edit',
                'parent_route' => 'item-list',
                'type' => 3,
            ],
            323 => [
                'name' => 'Delete',
                'route' => 'delete-item-view',
                'parent_route' => 'item-list',
                'type' => 3,
            ],
            324 => [
                'name' => 'Item Store',
                'route' => 'item-store',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            325 => [
                'name' => 'Add',
                'route' => 'item-store-store',
                'parent_route' => 'item-store',
                'type' => 3,
            ],
            326 => [
                'name' => 'Edit',
                'route' => 'item-store-edit',
                'parent_route' => 'item-store',
                'type' => 3,
            ],
            327 => [
                'name' => 'Delete',
                'route' => 'delete-store-view',
                'parent_route' => 'item-store',
                'type' => 3,
            ],
            328 => [
                'name' => 'Supplier',
                'route' => 'suppliers',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            329 => [
                'name' => 'Add',
                'route' => 'suppliers-store',
                'parent_route' => 'suppliers',
                'type' => 3,
            ],
            330 => [
                'name' => 'Edit',
                'route' => 'suppliers-edit',
                'parent_route' => 'suppliers',
                'type' => 3,
            ],
            331 => [
                'name' => 'Delete',
                'route' => 'suppliers-delete',
                'parent_route' => 'suppliers',
                'type' => 3,
            ],
            332 => [
                'name' => 'Item Receive',
                'route' => 'item-receive',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            333 => [
                'name' => 'Add',
                'route' => 'save-item-receive-data',
                'parent_route' => 'item-receive',
                'type' => 3,
            ],
            334 => [
                'name' => 'Item Receive List',
                'route' => 'item-receive-list',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            335 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'item-receive-list',
                'type' => 3,
            ],
            336 => [
                'name' => 'Edit',
                'route' => 'edit-item-receive',
                'parent_route' => 'item-receive-list',
                'type' => 3,
            ],
            337 => [
                'name' => 'View',
                'route' => 'view-receive-payments',
                'parent_route' => 'item-receive-list',
                'type' => 3,
            ],
            338 => [
                'name' => 'Cancel',
                'route' => 'delete-item-receive-view',
                'parent_route' => 'item-receive-list',
                'type' => 3,
            ],
            339 => [
                'name' => 'Item Sell',
                'route' => 'item-sell-list',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            340 => [
                'name' => 'Add',
                'route' => 'save-item-sell-data',
                'parent_route' => 'item-sell-list',
                'type' => 3,
            ],
            341 => [
                'name' => 'Edit',
                'route' => 'edit-item-sell',
                'parent_route' => 'item-sell-list',
                'type' => 3,
            ],
            342 => [
                'name' => 'Delete',
                'route' => 'delete-item-sale-view',
                'parent_route' => 'item-sell-list',
                'type' => 3,
            ],
            343 => [
                'name' => 'Add Payment',
                'route' => 'add-payment-sell',
                'parent_route' => 'item-sell-list',
                'type' => 3,
            ],
            344 => [
                'name' => 'View Payment',
                'route' => 'view-sell-payments',
                'parent_route' => 'item-sell-list',
                'type' => 3,
            ],
            345 => [
                'name' => 'Item Issue',
                'route' => 'item-issue',
                'parent_route' => 'inventory',
                'type' => 2,
            ],
            346 => [
                'name' => 'Add',
                'route' => 'save-item-issue-data',
                'parent_route' => 'item-issue',
                'type' => 3,
            ],
            347 => [
                'name' => 'Return',
                'route' => 'return-item-view',
                'parent_route' => 'item-issue',
                'type' => 3,
            ],
            348 => [
                'name' => 'Transport',
                'route' => 'transport',
                'parent_route' => null,
                'type' => 1,
            ],
            349 => [
                'name' => 'Routes',
                'route' => 'transport-route',
                'parent_route' => 'transport',
                'type' => 2,
            ],
            350 => [
                'name' => 'Add',
                'route' => 'transport-route-store',
                'parent_route' => 'transport-route',
                'type' => 3,
            ],
            351 => [
                'name' => 'Edit',
                'route' => 'transport-route-edit',
                'parent_route' => 'transport-route',
                'type' => 3,
            ],
            352 => [
                'name' => 'Delete',
                'route' => 'transport-route-delete',
                'parent_route' => 'transport-route',
                'type' => 3,
            ],
            353 => [
                'name' => 'Vehicle',
                'route' => 'vehicle',
                'parent_route' => 'transport',
                'type' => 2,
            ],
            354 => [
                'name' => 'Add',
                'route' => 'vehicle-store',
                'parent_route' => 'vehicle',
                'type' => 3,
            ],
            355 => [
                'name' => 'Edit',
                'route' => 'vehicle-edit',
                'parent_route' => 'vehicle',
                'type' => 3,
            ],
            356 => [
                'name' => 'Delete',
                'route' => 'vehicle-delete',
                'parent_route' => 'vehicle',
                'type' => 3,
            ],
            357 => [
                'name' => 'Assign Vehicle',
                'route' => 'assign-vehicle',
                'parent_route' => 'transport',
                'type' => 2,
            ],
            358 => [
                'name' => 'Add',
                'route' => 'assign-vehicle-store',
                'parent_route' => 'assign-vehicle',
                'type' => 3,
            ],
            359 => [
                'name' => 'Edit',
                'route' => 'assign-vehicle-edit',
                'parent_route' => 'assign-vehicle',
                'type' => 3,
            ],
            360 => [
                'name' => 'Delete',
                'route' => 'assign-vehicle-delete',
                'parent_route' => 'assign-vehicle',
                'type' => 3,
            ],
            361 => [
                'name' => 'Student Transport Report',
                'route' => 'student_transport_report',
                'parent_route' => 'transport',
                'type' => 2,
            ],
            362 => [
                'name' => 'Dormitory',
                'route' => 'dormitory',
                'parent_route' => null,
                'type' => 1,
            ],
            363 => [
                'name' => 'Dormitory Rooms',
                'route' => 'room-list',
                'parent_route' => 'dormitory',
                'type' => 2,
            ],
            364 => [
                'name' => 'Add',
                'route' => 'room-list-store',
                'parent_route' => 'room-list',
                'type' => 3,
            ],
            365 => [
                'name' => 'Edit',
                'route' => 'room-list-edit',
                'parent_route' => 'room-list',
                'type' => 3,
            ],
            366 => [
                'name' => 'Delete',
                'route' => 'room-list-delete',
                'parent_route' => 'room-list',
                'type' => 3,
            ],
            367 => [
                'name' => 'Dormitory',
                'route' => 'dormitory-list',
                'parent_route' => 'dormitory',
                'type' => 2,
            ],
            368 => [
                'name' => 'Add',
                'route' => 'dormitory-list-store',
                'parent_route' => 'dormitory-list',
                'type' => 3,
            ],
            369 => [
                'name' => 'Edit',
                'route' => 'dormitory-list-edit',
                'parent_route' => 'dormitory-list',
                'type' => 3,
            ],
            370 => [
                'name' => 'Delete',
                'route' => 'dormitory-list-delete',
                'parent_route' => 'dormitory-list',
                'type' => 3,
            ],
            371 => [
                'name' => 'Room Type',
                'route' => 'room-type',
                'parent_route' => 'dormitory',
                'type' => 2,
            ],
            372 => [
                'name' => 'Add',
                'route' => 'room-type-store',
                'parent_route' => 'room-type',
                'type' => 3,
            ],
            373 => [
                'name' => 'Edit',
                'route' => 'room-type-edit',
                'parent_route' => 'room-type',
                'type' => 3,
            ],
            374 => [
                'name' => 'Delete',
                'route' => 'room-type-delete',
                'parent_route' => 'room-type',
                'type' => 3,
            ],
            375 => [
                'name' => 'Student Dormitory Report',
                'route' => 'student_dormitory_report',
                'parent_route' => 'dormitory',
                'type' => 2,
            ],
            376 => [
                'name' => 'Reports',
                'route' => 'reports',
                'parent_route' => null,
                'type' => 1,
            ],
            377 => [
                'name' => 'Guardian Reports',
                'route' => 'guardian_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            378 => [
                'name' => 'Student History',
                'route' => 'student_history',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            379 => [
                'name' => 'Student Login Report',
                'route' => 'student_login_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            380 => [
                'name' => 'Update',
                'route' => 'student_login_update',
                'parent_route' => 'student_login_report',
                'type' => 3,
            ],
            381 => [
                'name' => 'Fees Statement',
                'route' => 'fees_statement',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            382 => [
                'name' => 'Balance Fees Report',
                'route' => 'balance_fees_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            383 => [
                'name' => 'Collection Report',
                'route' => 'transaction_report',
                'parent_route' => 'fees_collection',
                'type' => 3,
            ],
            384 => [
                'name' => 'Class Report',
                'route' => 'class_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            385 => [
                'name' => 'Class Routine',
                'route' => 'class_routine_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            386 => [
                'name' => 'Exam Routine',
                'route' => 'exam_routine_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            387 => [
                'name' => 'Teacher Class Routine',
                'route' => 'teacher_class_routine_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            388 => [
                'name' => 'Merit List Report',
                'route' => 'merit_list_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            389 => [
                'name' => 'Online Exam Report',
                'route' => 'online_exam_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            390 => [
                'name' => 'Mark Sheet Report',
                'route' => 'mark_sheet_report_student',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            391 => [
                'name' => 'Tabulation Sheet Report',
                'route' => 'tabulation_sheet_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            392 => [
                'name' => 'Progress Card Report',
                'route' => 'progress_card_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            394 => [
                'name' => 'User Log',
                'route' => 'user_log',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            395 => [
                'name' => 'Add',
                'route' => '',
                'parent_route' => 'user_log',
                'type' => 3,
            ],
            396 => [
                'name' => 'Edit',
                'route' => '',
                'parent_route' => 'user_log',
                'type' => 3,
            ],
            397 => [
                'name' => 'Exam Setup Edit',
                'route' => 'exam-edit',
                'parent_route' => 'exam',
                'type' => 3,
            ],
            398 => [
                'name' => 'System Settings',
                'route' => 'system_settings',
                'parent_route' => null,
                'type' => 1,
            ],
            399 => [
                'name' => 'Module Manager',
                'route' => 'manage-adons',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            400 => [
                'name' => 'Verify',
                'route' => 'manage-adons-verify',
                'parent_route' => 'manage-adons',
                'type' => 3,
            ],
            401 => [
                'name' => 'Manage Currency',
                'route' => 'manage-currency',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            402 => [
                'name' => 'Add',
                'route' => 'currency-store',
                'parent_route' => 'manage-currency',
                'type' => 3,
            ],
            403 => [
                'name' => 'Edit',
                'route' => 'currency_edit',
                'parent_route' => 'manage-currency',
                'type' => 3,
            ],
            404 => [
                'name' => 'Delete',
                'route' => 'currency_delete',
                'parent_route' => 'manage-currency',
                'type' => 3,
            ],
            405 => [
                'name' => 'General Settings',
                'route' => 'general-settings',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            406 => [
                'name' => 'Logo Change',
                'route' => 'update-school-logo',
                'parent_route' => 'general-settings',
                'type' => 3,
            ],
            407 => [
                'name' => 'Favicon Change',
                'route' => 'update-school-favicon',
                'parent_route' => 'general-settings',
                'type' => 3,
            ],
            408 => [
                'name' => 'Edit',
                'route' => 'update-general-settings',
                'parent_route' => 'general-settings',
                'type' => 3,
            ],
            409 => [
                'name' => 'Update',
                'route' => 'update-general-settings',
                'parent_route' => 'general-settings',
                'type' => 3,
            ],
            410 => [
                'name' => 'Email Setting',
                'route' => 'email-settings',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            411 => [
                'name' => 'Update',
                'route' => 'update-email-settings-data',
                'parent_route' => 'email-settings',
                'type' => 3,
            ],
            412 => [
                'name' => 'Payment Method Settings',
                'route' => 'payment-method-settings',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            413 => [
                'name' => 'Gateway Update',
                'route' => 'is-active-payment',
                'parent_route' => 'payment-method-settings',
                'type' => 3,
            ],
            414 => [
                'name' => 'Gateway Info Update',
                'route' => 'update-payment-gateway',
                'parent_route' => 'payment-method-settings',
                'type' => 3,
            ],
            415 => [
                'name' => 'Stripe Update',
                'route' => '',
                'parent_route' => 'payment-method-settings',
                'type' => 3,
            ],
            416 => [
                'name' => 'Paystack Update',
                'route' => '',
                'parent_route' => 'payment-method-settings',
                'type' => 3,
            ],
            417 => [
                'name' => 'Role & Permission',
                'route' => 'role_permission',
                'parent_route' => null,
                'type' => 1,
            ],
            418 => [
                'name' => 'Add',
                'route' => 'rolepermission/role-store',
                'parent_route' => 'rolepermission/role',
                'type' => 3,
            ],
            419 => [
                'name' => 'Edit',
                'route' => 'rolepermission/role-edit',
                'parent_route' => 'rolepermission/role',
                'type' => 3,
            ],
            420 => [
                'name' => 'Delete',
                'route' => 'rolepermission/role-delete',
                'parent_route' => 'rolepermission/role',
                'type' => 3,
            ],
            421 => [
                'name' => 'Login Permission',
                'route' => 'login-access-control',
                'parent_route' => 'role_permission',
                'type' => 2,
            ],
            422 => [
                'name' => 'On',
                'route' => 'login-access-control-on',
                'parent_route' => 'login-access-control',
                'type' => 3,
            ],
            423 => [
                'name' => 'Off',
                'route' => 'login-access-control-off',
                'parent_route' => 'login-access-control',
                'type' => 3,
            ],
            424 => [
                'name' => 'Optional Subject Setup',
                'route' => 'class_optional',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            425 => [
                'name' => 'Add',
                'route' => 'optional_subject_setup_post',
                'parent_route' => 'class_optional',
                'type' => 3,
            ],
            426 => [
                'name' => 'Edit',
                'route' => 'class_optional_edit',
                'parent_route' => 'class_optional',
                'type' => 3,
            ],
            427 => [
                'name' => 'Delete',
                'route' => 'delete_optional_subject',
                'parent_route' => 'class_optional',
                'type' => 3,
            ],
            428 => [
                'name' => 'Base Setup',
                'route' => 'base_setup',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            429 => [
                'name' => 'Add',
                'route' => 'base_setup_store',
                'parent_route' => 'base_setup',
                'type' => 3,
            ],
            430 => [
                'name' => 'Edit',
                'route' => 'base_setup_edit',
                'parent_route' => 'base_setup',
                'type' => 3,
            ],
            431 => [
                'name' => 'Delete',
                'route' => 'base_setup_delete',
                'parent_route' => 'base_setup',
                'type' => 3,
            ],
            432 => [
                'name' => 'Academic Year',
                'route' => 'academic-year',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            433 => [
                'name' => 'Add',
                'route' => 'academic-year-store',
                'parent_route' => 'academic-year',
                'type' => 3,
            ],
            434 => [
                'name' => 'Edit',
                'route' => 'academic-year-edit',
                'parent_route' => 'academic-year',
                'type' => 3,
            ],
            435 => [
                'name' => 'Delete',
                'route' => 'academic-year-delete',
                'parent_route' => 'academic-year',
                'type' => 3,
            ],
            436 => [
                'name' => 'Setup Exam Rule',
                'route' => 'custom-result-setting',
                'parent_route' => 'exam-settings',
                'type' => 3,
            ],
            437 => [
                'name' => 'Setup Final Exam Rule',
                'route' => 'custom-result-setting/store',
                'parent_route' => 'custom-result-setting',
                'type' => 3,
            ],
            438 => [
                'name' => 'Step Skip',
                'route' => 'exam.step.skip.update',
                'parent_route' => 'custom-result-setting',
                'type' => 3,
            ],
            439 => [
                'name' => 'Merit list Settings',
                'route' => 'merit-list-settings',
                'parent_route' => 'custom-result-setting',
                'type' => 3,
            ],
            440 => [
                'name' => 'Holiday',
                'route' => 'holiday',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            441 => [
                'name' => 'Add',
                'route' => 'holiday-store',
                'parent_route' => 'holiday',
                'type' => 3,
            ],
            442 => [
                'name' => 'Edit',
                'route' => 'holiday-edit',
                'parent_route' => 'holiday',
                'type' => 3,
            ],
            443 => [
                'name' => 'Delete',
                'route' => 'delete-holiday-data-view',
                'parent_route' => 'holiday',
                'type' => 3,
            ],
            444 => [
                'name' => 'Sms Settings',
                'route' => 'sms-settings',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            445 => [
                'name' => ' Select SMS Service',
                'route' => 'update-clickatell-data',
                'parent_route' => 'sms-settings',
                'type' => 3,
            ],
            446 => [
                'name' => 'Twilio Update',
                'route' => 'update-twilio-data',
                'parent_route' => 'sms-settings',
                'type' => 3,
            ],
            447 => [
                'name' => 'MSG91 Update',
                'route' => 'update-msg91-data',
                'parent_route' => 'sms-settings',
                'type' => 3,
            ],
            448 => [
                'name' => 'Weekend',
                'route' => 'weekend',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],

            451 => [
                'name' => 'Language Settings',
                'route' => 'language-settings',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            452 => [
                'name' => 'Add',
                'route' => 'language-add',
                'parent_route' => 'language-settings',
                'type' => 3,
            ],
            453 => [
                'name' => 'Make Default',
                'route' => 'change-language',
                'parent_route' => 'language-settings',
                'type' => 3,
            ],
            454 => [
                'name' => 'Setup',
                'route' => 'language-setup',
                'parent_route' => 'language-settings',
                'type' => 3,
            ],
            455 => [
                'name' => 'Remove',
                'route' => 'language-delete',
                'parent_route' => 'language-settings',
                'type' => 3,
            ],
            456 => [
                'name' => 'Backup',
                'route' => 'backup-settings',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            457 => [
                'name' => 'Add',
                'route' => 'backup-store',
                'parent_route' => 'backup-settings',
                'type' => 3,
            ],
            458 => [
                'name' => 'Download',
                'route' => 'download-files',
                'parent_route' => 'backup-settings',
                'type' => 3,
            ],
            459 => [
                'name' => 'Delete',
                'route' => 'delete_database',
                'parent_route' => 'backup-settings',
                'type' => 3,
            ],
            460 => [
                'name' => 'Image',
                'route' => 'get-backup-files',
                'parent_route' => 'backup-settings',
                'type' => 3,
            ],
            461 => [
                'name' => 'Full Project',
                'route' => '',
                'parent_route' => 'backup-settings',
                'type' => 3,
            ],
            462 => [
                'name' => 'Database',
                'route' => 'get-backup-db',
                'parent_route' => 'backup-settings',
                'type' => 3,
            ],
            463 => [
                'name' => 'Header Option',
                'route' => 'button-disable-enable',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            464 => [
                'name' => 'Custom URL Update',
                'route' => 'update-website-url',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            465 => [
                'name' => 'Status Change',
                'route' => 'status-change',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            466 => [
                'name' => 'Website Off',
                'route' => 'status-disable',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            467 => [
                'name' => 'Dashboard On',
                'route' => 'dashboard-enable',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            468 => [
                'name' => 'Dashboard Off',
                'route' => 'dashboard-disable',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            469 => [
                'name' => 'Report On',
                'route' => 'report-enable',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            470 => [
                'name' => 'Report Off',
                'route' => 'report-disable',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            471 => [
                'name' => 'Language On',
                'route' => 'lang-enable',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            472 => [
                'name' => 'Language Off',
                'route' => 'lang-disable',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            473 => [
                'name' => 'Style On',
                'route' => '',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            474 => [
                'name' => 'Style Off',
                'route' => '',
                'parent_route' => 'button-disable-enable',
                'type' => 3,
            ],
            478 => [
                'name' => 'About & Update',
                'route' => 'update-system',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            479 => [
                'name' => 'Add',
                'route' => 'admin/update-system',
                'parent_route' => 'update-system',
                'type' => 3,
            ],
            480 => [
                'name' => 'Email Template',
                'route' => 'templatesettings.email-template',
                'parent_route' => 'communicate',
                'type' => 2,
            ],
            481 => [
                'name' => 'Save',
                'route' => '',
                'parent_route' => 'templatesettings.email-template',
                'type' => 3,
            ],
            482 => [
                'name' => 'API Permission',
                'route' => 'api/permission',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            483 => [
                'name' => 'On',
                'route' => '',
                'parent_route' => '',
                'type' => 3,
            ],
            484 => [
                'name' => 'Off',
                'route' => '',
                'parent_route' => '',
                'type' => 3,
            ],
            485 => [
                'name' => 'Style',
                'route' => 'style',
                'parent_route' => null,
                'type' => 1,
            ],
            486 => [
                'name' => 'Background Settings',
                'route' => 'background-setting',
                'parent_route' => 'style',
                'type' => 2,
            ],
            487 => [
                'name' => 'Add',
                'route' => 'background-settings-store',
                'parent_route' => 'background-setting',
                'type' => 3,
            ],
            488 => [
                'name' => 'Delete',
                'route' => 'background-setting-delete',
                'parent_route' => 'background-setting',
                'type' => 3,
            ],
            489 => [
                'name' => 'Make Default',
                'route' => 'background_setting-status',
                'parent_route' => 'background-setting',
                'type' => 3,
            ],
            490 => [
                'name' => 'Color Theme',
                'route' => 'color-style',
                'parent_route' => 'style',
                'type' => 2,
            ],
            491 => [
                'name' => 'Make Default',
                'route' => 'themes.default',
                'parent_route' => 'color-style',
                'type' => 3,
            ],
            492 => [
                'name' => 'Front Settings',
                'route' => 'front_settings',
                'parent_route' => null,
                'type' => 1,
            ],
            493 => [
                'name' => 'Home Page',
                'route' => 'admin-home-page',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            494 => [
                'name' => 'Update',
                'route' => 'admin-home-page-update',
                'parent_route' => 'admin-home-page',
                'type' => 3,
            ],
            495 => [
                'name' => 'News List',
                'route' => 'news_index',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            496 => [
                'name' => 'View',
                'route' => 'newsDetails',
                'parent_route' => 'news_index',
                'type' => 3,
            ],
            497 => [
                'name' => 'Add',
                'route' => 'store_news',
                'parent_route' => 'news_index',
                'type' => 3,
            ],
            498 => [
                'name' => 'Edit',
                'route' => 'edit-news',
                'parent_route' => 'news_index',
                'type' => 3,
            ],
            499 => [
                'name' => 'Delete',
                'route' => 'delete-news',
                'parent_route' => 'news_index',
                'type' => 3,
            ],
            500 => [
                'name' => 'News Category',
                'route' => 'news-category',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            501 => [
                'name' => 'Add',
                'route' => 'store_news_category',
                'parent_route' => 'news-category',
                'type' => 3,
            ],
            502 => [
                'name' => 'Edit',
                'route' => 'edit-news-category',
                'parent_route' => 'news-category',
                'type' => 3,
            ],
            503 => [
                'name' => 'Delete',
                'route' => 'for-delete-news-category',
                'parent_route' => 'news-category',
                'type' => 3,
            ],
            504 => [
                'name' => 'Testimonial',
                'route' => 'testimonial_index',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            505 => [
                'name' => 'View',
                'route' => 'testimonial-details',
                'parent_route' => 'testimonial_index',
                'type' => 3,
            ],
            506 => [
                'name' => 'Add',
                'route' => 'store_testimonial',
                'parent_route' => 'testimonial_index',
                'type' => 3,
            ],
            507 => [
                'name' => 'Edit',
                'route' => 'edit-testimonial',
                'parent_route' => 'testimonial_index',
                'type' => 3,
            ],
            508 => [
                'name' => 'Delete',
                'route' => 'for-delete-testimonial',
                'parent_route' => 'testimonial_index',
                'type' => 3,
            ],
            509 => [
                'name' => 'Course List',
                'route' => 'course-list',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            510 => [
                'name' => 'View',
                'route' => 'course-Details-admin',
                'parent_route' => 'course-list',
                'type' => 3,
            ],
            511 => [
                'name' => 'Add',
                'route' => 'store_course',
                'parent_route' => 'course-list',
                'type' => 3,
            ],
            512 => [
                'name' => 'Edit',
                'route' => 'edit-course',
                'parent_route' => 'course-list',
                'type' => 3,
            ],
            513 => [
                'name' => 'Delete',
                'route' => 'delete-course',
                'parent_route' => 'course-list',
                'type' => 3,
            ],
            514 => [
                'name' => 'Contact Page',
                'route' => 'conpactPage',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            515 => [
                'name' => 'Store',
                'route' => 'contactPageStore',
                'parent_route' => 'conpactPage',
                'type' => 3,
            ],
            516 => [
                'name' => 'Edit',
                'route' => 'contactPageEdit',
                'parent_route' => 'conpactPage',
                'type' => 3,
            ],
            517 => [
                'name' => 'Contact Messages',
                'route' => 'contactMessage',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            519 => [
                'name' => 'Delete',
                'route' => 'delete-message',
                'parent_route' => 'contactMessage',
                'type' => 3,
            ],
            520 => [
                'name' => 'About Us',
                'route' => 'about-page',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            521 => [
                'name' => 'View',
                'route' => 'about-page/view',
                'parent_route' => 'about-page',
                'type' => 3,
            ],
            522 => [
                'name' => 'Edit',
                'route' => 'about-page/edit',
                'parent_route' => 'about-page',
                'type' => 3,
            ],
            523 => [
                'name' => 'News Heading',
                'route' => 'news-heading-update',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            524 => [
                'name' => 'Update',
                'route' => '',
                'parent_route' => 'news-heading-update',
                'type' => 3,
            ],
            525 => [
                'name' => 'Course Details Heading',
                'route' => 'course-heading-update',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            526 => [
                'name' => 'Update',
                'route' => 'course-heading-update',
                'parent_route' => 'course-heading-update',
                'type' => 3,
            ],
            527 => [
                'name' => 'Footer Widget',
                'route' => 'custom-links',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            528 => [
                'name' => 'Update',
                'route' => '',
                'parent_route' => 'custom-links',
                'type' => 3,
            ],
            529 => [
                'name' => 'Social Media',
                'route' => 'social-media',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            530 => [
                'name' => 'Add',
                'route' => 'social-media-store',
                'parent_route' => 'social-media',
                'type' => 3,
            ],
            531 => [
                'name' => 'Edit',
                'route' => 'social-media-edit',
                'parent_route' => 'social-media',
                'type' => 3,
            ],
            532 => [
                'name' => 'Delete',
                'route' => 'social-media-delete',
                'parent_route' => 'social-media',
                'type' => 3,
            ],
            533 => [
                'name' => 'Subject Wise Attendance',
                'route' => 'subject-wise-attendance',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            534 => [
                'name' => 'Save',
                'route' => 'subject-attendance-store',
                'parent_route' => 'subject-wise-attendance',
                'type' => 3,
            ],
            535 => [
                'name' => 'Subject Wise Attendance Report',
                'route' => 'subject-attendance-report',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            536 => [
                'name' => 'Print',
                'route' => 'subject-attendance/print',
                'parent_route' => 'subject-attendance-report',
                'type' => 3,
            ],
            537 => [
                'name' => 'Optional Subject',
                'route' => 'optional-subject',
                'parent_route' => 'academics',
                'type' => 2,
            ],
            538 => [
                'name' => 'Student Report',
                'route' => 'student_report',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            539 => [
                'name' => 'Previous Result',
                'route' => 'previous-class-results',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            540 => [
                'name' => 'previous record',
                'route' => 'previous-record',
                'parent_route' => 'reports',
                'type' => 2,
            ],
            541 => [
                'name' => 'Assign Permission',
                'route' => 'rolepermission/assign-permission',
                'parent_route' => 'rolepermission/role',
                'type' => 3,
            ],

            549 => [
                'name' => 'Language',
                'route' => 'language-list',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            550 => [
                'name' => 'Add',
                'route' => 'language_store',
                'parent_route' => 'language-list',
                'type' => 3,
            ],
            551 => [
                'name' => 'Edit',
                'route' => 'language_edit',
                'parent_route' => 'language-list',
                'type' => 3,
            ],
            552 => [
                'name' => 'Delete',
                'route' => 'language_delete',
                'parent_route' => 'language-list',
                'type' => 3,
            ],
            553 => [
                'name' => 'Add',
                'route' => 'apply-leave-store',
                'parent_route' => 'apply-leave',
                'type' => 3,
            ],

            577 => [
                'name' => 'Status On',
                'route' => '',
                'parent_route' => 'staff_directory',
                'type' => 3,
            ],
            578 => [
                'name' => 'Status Off',
                'route' => '',
                'parent_route' => 'staff_directory',
                'type' => 3,
            ],
            579 => [
                'name' => 'Subject',
                'route' => 'library_subject',
                'parent_route' => 'library',
                'type' => 2,
            ],
            580 => [
                'name' => 'Add',
                'route' => 'library_subject_store',
                'parent_route' => 'library_subject',
                'type' => 3,
            ],
            581 => [
                'name' => 'Edit',
                'route' => 'library_subject_edit',
                'parent_route' => 'library_subject',
                'type' => 3,
            ],
            582 => [
                'name' => 'Delete',
                'route' => 'library_subject_delete',
                'parent_route' => 'library_subject',
                'type' => 3,
            ],
            585 => [
                'name' => 'Role',
                'route' => 'rolepermission/role',
                'parent_route' => 'role_permission',
                'type' => 2,
            ],
            586 => [
                'name' => 'edit',
                'route' => 'upload-content-edit',
                'parent_route' => 'upload-content',
                'type' => 3,
            ],
            587 => [
                'name' => 'edit',
                'route' => 'upload-content-edit',
                'parent_route' => 'assignment-list',
                'type' => 3,
            ],
            588 => [
                'name' => 'edit',
                'route' => 'other-download-list-edit',
                'parent_route' => 'other-download-list',
                'type' => 3,
            ],

            638 => [
                'name' => 'Human Resource',
                'route' => 'human_resource',
                'parent_route' => null,
                'type' => 1,
            ],

            650 => [
                'name' => 'Header Menu Manager',
                'route' => 'header-menu-manager',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            651 => [
                'name' => 'Add',
                'route' => 'add-element',
                'parent_route' => 'header-menu-manager',
                'type' => 3,
            ],
            652 => [
                'name' => 'Edit',
                'route' => 'element-update',
                'parent_route' => 'header-menu-manager',
                'type' => 3,
            ],
            653 => [
                'name' => 'Delete',
                'route' => 'delete-element',
                'parent_route' => 'header-menu-manager',
                'type' => 3,
            ],
            654 => [
                'name' => 'Pages',
                'route' => 'page-list',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            655 => [
                'name' => 'View',
                'route' => 'view-page',
                'parent_route' => 'page-list',
                'type' => 3,
            ],
            656 => [
                'name' => 'Add',
                'route' => 'save-page-data',
                'parent_route' => 'page-list',
                'type' => 3,
            ],
            657 => [
                'name' => 'Edit',
                'route' => 'edit-page',
                'parent_route' => 'page-list',
                'type' => 3,
            ],
            658 => [
                'name' => 'Delete',
                'route' => 'delete-page',
                'parent_route' => 'page-list',
                'type' => 3,
            ],
            659 => [
                'name' => 'Download',
                'route' => 'download-page',
                'parent_route' => 'page-list',
                'type' => 3,
            ],

            663 => [
                'name' => 'Student Export',
                'route' => 'all-student-export',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            664 => [
                'name' => 'Export To CSV',
                'route' => 'all-student-export-excel',
                'parent_route' => 'all-student-export',
                'type' => 3,
            ],
            665 => [
                'name' => 'Export To PDF',
                'route' => 'all-student-export-pdf',
                'parent_route' => 'all-student-export',
                'type' => 3,
            ],
            669 => [
                'name' => 'Designation',
                'route' => 'designation',
                'parent_route' => 'human_resource',
                'type' => 3,
            ],
            670 => [
                'name' => 'Department',
                'route' => 'department',
                'parent_route' => 'human_resource',
                'type' => 3,
            ],
            671 => [
                'name' => 'Add Staff',
                'route' => 'addStaff',
                'parent_route' => 'human_resource',
                'type' => 3,
            ],
            672 => [
                'name' => 'Staff Directory',
                'route' => 'staff_directory',
                'parent_route' => 'human_resource',
                'type' => 3,
            ],
            673 => [
                'name' => 'Course Category',
                'route' => 'course-category',
                'parent_route' => 'front_settings',
                'type' => 2,
            ],
            674 => [
                'name' => 'Add',
                'route' => 'store-course-category',
                'parent_route' => 'course-category',
                'type' => 3,
            ],
            675 => [
                'name' => 'Edit',
                'route' => 'edit-course-category',
                'parent_route' => 'course-category',
                'type' => 3,
            ],
            676 => [
                'name' => 'Delete',
                'route' => 'delete-course-category',
                'parent_route' => 'course-category',
                'type' => 3,
            ],

            700 => [
                'name' => 'Report',
                'route' => 'accounts-report',
                'parent_route' => 'accounts',
                'type' => 2,
            ],
            701 => [
                'name' => 'Fine Report',
                'route' => 'fine-report',
                'parent_route' => 'accounts-report',
                'type' => 3,
            ],
            702 => [
                'name' => 'Payroll Report',
                'route' => 'accounts-payroll-report',
                'parent_route' => 'accounts-report',
                'type' => 3,
            ],
            703 => [
                'name' => 'Transaction',
                'route' => 'transaction',
                'parent_route' => 'accounts-report',
                'type' => 3,
            ],
            704 => [
                'name' => 'Fund Transfer',
                'route' => 'fund-transfer',
                'parent_route' => 'accounts',
                'type' => 2,
            ],
            705 => [
                'name' => 'Transfer',
                'route' => 'fund-transfer-store',
                'parent_route' => 'fund-transfer',
                'type' => 3,
            ],
            706 => [
                'name' => 'Format Settings',
                'route' => 'exam-settings',
                'parent_route' => '',
                'type' => 3,
            ],
            707 => [
                'name' => 'Add',
                'route' => 'save-exam-content',
                'parent_route' => 'exam-settings',
                'type' => 3,
            ],
            708 => [
                'name' => 'Edit',
                'route' => 'edit-exam-settings',
                'parent_route' => 'exam-settings',
                'type' => 3,
            ],
            709 => [
                'name' => 'Delete',
                'route' => 'delete-content',
                'parent_route' => 'exam-settings',
                'type' => 3,
            ],
            710 => [
                'name' => 'Sms Templete',
                'route' => 'sms-template-new',
                'parent_route' => 'communicate',
                'type' => 2,
            ],
            711 => [
                'name' => 'Add',
                'route' => 'sms-template-new-store',
                'parent_route' => 'sms-template-new',
                'type' => 3,
            ],
            712 => [
                'name' => 'Add Staff',
                'route' => 'addStaff',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            800 => [
                'name' => 'Lesson',
                'route' => 'lesson',
                'parent_route' => null,
                'type' => 1,
            ],
            801 => [
                'name' => 'Lesson',
                'route' => 'lesson',
                'parent_route' => 'lesson',
                'type' => 1,
            ],
            802 => [
                'name' => 'Add',
                'route' => 'lesson.create-store',
                'parent_route' => 'lesson',
                'type' => 3,
            ],
            803 => [
                'name' => 'Edit',
                'route' => 'lesson-edit',
                'parent_route' => 'lesson',
                'type' => 3,
            ],
            804 => [
                'name' => 'Delete',
                'route' => 'lesson-delete',
                'parent_route' => 'lesson',
                'type' => 3,
            ],
            805 => [
                'name' => 'Topic',
                'route' => 'lesson.topic',
                'parent_route' => 'lesson',
                'type' => 1,
            ],
            806 => [
                'name' => 'Add',
                'route' => 'lesson.topic.store',
                'parent_route' => 'lesson.topic',
                'type' => 3,
            ],
            807 => [
                'name' => 'Edit',
                'route' => 'topic-edit',
                'parent_route' => 'lesson.topic',
                'type' => 3,
            ],
            808 => [
                'name' => 'Delete',
                'route' => 'topic-delete',
                'parent_route' => 'lesson.topic',
                'type' => 3,
            ],
            809 => [
                'name' => 'Topic Overview',
                'route' => 'topic-overview',
                'parent_route' => 'lesson',
                'type' => 1,
            ],
            810 => [
                'name' => 'Lesson Plan',
                'route' => 'lesson.lesson-planner',
                'parent_route' => 'lesson',
                'type' => 1,
            ],
            811 => [
                'name' => 'Add',
                'route' => 'add-new-lesson-plan',
                'parent_route' => 'lesson.lesson-planner',
                'type' => 3,
            ],
            812 => [
                'name' => 'Edit',
                'route' => 'edit-lesson-planner-lesson',
                'parent_route' => 'lesson.lesson-planner',
                'type' => 3,
            ],
            813 => [
                'name' => 'Delete',
                'route' => 'delete-lesson-planner-lesson',
                'parent_route' => 'lesson.lesson-planner',
                'type' => 3,
            ],
            814 => [
                'name' => 'view',
                'route' => 'view-lesson-planner-lesson',
                'parent_route' => 'lesson.lesson-planner',
                'type' => 3,
            ],
            815 => [
                'name' => 'Lesson Plan Overview',
                'route' => 'lesson.lessonPlan-overiew',
                'parent_route' => 'lesson',
                'type' => 1,
            ],

            833 => [
                'name' => 'My Lesson Plan ',
                'route' => 'view-teacher-lessonPlan',
                'parent_route' => 'lesson',
                'type' => 1,
            ],
            834 => [
                'name' => 'My Lesson Plan Overview',
                'route' => 'view-teacher-lessonPlan-overview',
                'parent_route' => 'lesson',
                'type' => 1,
            ],
            835 => [
                'name' => 'Lesson Plan Setting',
                'route' => 'lesson.lesson-planner.setting',
                'parent_route' => 'lesson',
                'type' => 1,
            ],
            840 => [
                'name' => 'Report',
                'route' => '',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            850 => [
                'name' => 'BigBlueButton',
                'route' => 'bigbluebutton',
                'parent_route' => null,
                'type' => 1,
            ],

            870 => [
                'name' => 'Settings',
                'route' => '',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            871 => [
                'name' => 'Bank Payment',
                'route' => 'bank-payment-slip',
                'parent_route' => 'fees_collection',
                'type' => 2,
            ],
            875 => [
                'name' => 'Online Exam',
                'route' => 'online_exam',
                'parent_route' => null,
                'type' => 1,
            ],
            900 => [
                'name' => 'Chat',
                'route' => 'chat',
                'parent_route' => null,
                'type' => 1,
            ],
            901 => [
                'name' => 'Chat Box',
                'route' => 'chat.index',
                'parent_route' => 'chat',
                'type' => 2,
            ],
            902 => [
                'name' => 'New Chat',
                'route' => '',
                'parent_route' => 'chat.index',
                'type' => 3,
            ],
            903 => [
                'name' => 'Invitation',
                'route' => 'chat.invitation',
                'parent_route' => 'chat',
                'type' => 2,
            ],
            904 => [
                'name' => 'Blocked User',
                'route' => 'chat.blocked.users',
                'parent_route' => 'chat',
                'type' => 2,
            ],
            905 => [
                'name' => 'Chat Settings',
                'route' => 'chat.settings',
                'parent_route' => 'chat',
                'type' => 2,
            ],
            920 => [
                'name' => 'Bulk Print',
                'route' => 'bulk_print',
                'parent_route' => null,
                'type' => 1,
            ],
            921 => [
                'name' => 'Id Card',
                'route' => 'student-id-card-bulk-print',
                'parent_route' => 'bulk_print',
                'type' => 2,
            ],
            922 => [
                'name' => 'Student Certificate',
                'route' => 'certificate-bulk-print',
                'parent_route' => 'bulk_print',
                'type' => 2,
            ],
            //  923 =>
            //  array (
            //    'name' => 'Staff Id Card',
            //    'route' => 'staff-id-card-bulk-print',
            //    'parent_route' => 'bulk_print',
            //    'type' => 2,
            //  ),
            924 => [
                'name' => 'Payroll Bulk Print',
                'route' => 'payroll-bulk-print',
                'parent_route' => 'bulk_print',
                'type' => 2,
            ],
            925 => [
                'name' => 'Fees Invoice Bulk Print Settings',
                'route' => 'invoice-settings',
                'parent_route' => 'bulk_print',
                'type' => 2,
            ],
            926 => [
                'name' => 'Fees invoice Bulk Print',
                'route' => 'fees-bulk-print',
                'parent_route' => 'bulk_print',
                'type' => 2,
            ],
            950 => [
                'name' => 'Time Setup',
                'route' => 'notification_time_setup',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            951 => [
                'name' => 'Student Settings',
                'route' => 'student_settings',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            952 => [
                'name' => 'Settings',
                'route' => 'staff_settings',
                'parent_route' => 'human_resource',
                'type' => 2,
            ],
            1001 => [
                'name' => 'Edit',
                'route' => 'edit-fees-payment',
                'parent_route' => 'search_fees_payment',
                'type' => 3,
            ],
            1002 => [
                'name' => 'Delete',
                'route' => 'fees-payment-delete',
                'parent_route' => 'search_fees_payment',
                'type' => 3,
            ],
            1100 => [
                'name' => 'Custom Field',
                'route' => 'custom_field',
                'parent_route' => null,
                'type' => 1,
            ],
            1101 => [
                'name' => 'Student Registration',
                'route' => 'student-reg-custom-field',
                'parent_route' => 'custom_field',
                'type' => 2,
            ],
            1102 => [
                'name' => 'Add',
                'route' => 'store-student-registration-custom-field',
                'parent_route' => 'student-reg-custom-field',
                'type' => 3,
            ],
            1103 => [
                'name' => 'Edit',
                'route' => 'edit-custom-field',
                'parent_route' => 'student-reg-custom-field',
                'type' => 3,
            ],
            1104 => [
                'name' => 'Delete',
                'route' => 'delete-custom-field',
                'parent_route' => 'student-reg-custom-field',
                'type' => 3,
            ],
            1105 => [
                'name' => 'Staff Registration',
                'route' => 'staff-reg-custom-field',
                'parent_route' => 'custom_field',
                'type' => 2,
            ],
            1106 => [
                'name' => 'Add',
                'route' => 'store-staff-registration-custom-field',
                'parent_route' => 'staff-reg-custom-field',
                'type' => 3,
            ],
            1107 => [
                'name' => 'Edit',
                'route' => 'edit-staff-custom-field',
                'parent_route' => 'staff-reg-custom-field',
                'type' => 3,
            ],
            1108 => [
                'name' => 'Delete',
                'route' => 'delete-staff-custom-field',
                'parent_route' => 'staff-reg-custom-field',
                'type' => 3,
            ],
            1109 => [
                'name' => 'Wallet',
                'route' => 'wallet',
                'parent_route' => null,
                'type' => 1,
            ],
            1110 => [
                'name' => 'Pending Diposite',
                'route' => 'wallet.pending-diposit',
                'parent_route' => 'wallet',
                'type' => 2,
            ],
            1111 => [
                'name' => 'Approve',
                'route' => 'wallet.approve-payment',
                'parent_route' => 'wallet.reject-payment',
                'type' => 3,
            ],
            1112 => [
                'name' => 'Reject',
                'route' => 'wallet.reject-payment',
                'parent_route' => 'wallet.reject-payment',
                'type' => 3,
            ],
            1113 => [
                'name' => 'Download',
                'route' => 'wallet.download',
                'parent_route' => 'wallet.reject-payment',
                'type' => 3,
            ],
            1114 => [
                'name' => 'Approve Diposite',
                'route' => 'wallet.approve-diposit',
                'parent_route' => 'wallet',
                'type' => 2,
            ],
            1115 => [
                'name' => 'Download',
                'route' => '',
                'parent_route' => '',
                'type' => 2,
            ],
            1116 => [
                'name' => 'Reject Diposite',
                'route' => 'wallet.reject-diposit',
                'parent_route' => 'wallet',
                'type' => 2,
            ],
            1117 => [
                'name' => 'Download',
                'route' => '',
                'parent_route' => '',
                'type' => 2,
            ],
            1118 => [
                'name' => 'Wallet Transaction',
                'route' => 'wallet.wallet-transaction',
                'parent_route' => 'wallet',
                'type' => 2,
            ],
            1119 => [
                'name' => 'Wallet Refund Request',
                'route' => 'wallet.wallet-refund-request',
                'parent_route' => 'wallet',
                'type' => 2,
            ],
            1120 => [
                'name' => 'Approve',
                'route' => 'wallet.approve-refund',
                'parent_route' => 'wallet.wallet-refund-request',
                'type' => 2,
            ],
            1121 => [
                'name' => 'Reject',
                'route' => 'wallet.reject-refund',
                'parent_route',
                'parent_route' => 'wallet.wallet-refund-request',
                'type' => 2,
            ],
            1122 => [
                'name' => 'Download',
                'route' => 'wallet.reject-download',
                'parent_route',
                'parent_route' => 'wallet.wallet-refund-request',
                'type' => 2,
            ],
            1123 => [
                'name' => 'Wallet Report',
                'route' => 'wallet-report',
                'parent_route' => 'wallet',
                'type' => 2,
            ],
            1130 => [
                'name' => 'Fees',
                'route' => 'fees',
                'parent_route' => null,
                'type' => 1,
            ],
            1131 => [
                'name' => 'Fees Group',
                'route' => 'fees_group',
                'parent_route' => 'fees',
                'type' => 2,
            ],
            1132 => [
                'name' => 'Add',
                'route' => 'fees_group_store',
                'parent_route' => 'fees_group',
                'type' => 3,
            ],
            1133 => [
                'name' => 'Edit',
                'route' => 'fees_group_edit',
                'parent_route' => 'fees_group',
                'type' => 3,
            ],
            1134 => [
                'name' => 'Delete',
                'route' => 'fees_group_delete',
                'parent_route' => 'fees_group',
                'type' => 3,
            ],
            1135 => [
                'name' => 'Fees Type',
                'route' => 'fees_type',
                'parent_route' => 'fees',
                'type' => 2,
            ],
            1136 => [
                'name' => 'Add',
                'route' => 'fees_type_store',
                'parent_route' => 'fees_type',
                'type' => 3,
            ],
            1137 => [
                'name' => 'Edit',
                'route' => 'fees_type_edit',
                'parent_route' => 'fees_type',
                'type' => 3,
            ],
            1138 => [
                'name' => 'Delete',
                'route' => 'fees_type_delete',
                'parent_route' => 'fees_type',
                'type' => 3,
            ],
            1139 => [
                'name' => 'Fees Invoice',
                'route' => 'fees.fees-invoice',
                'parent_route' => 'fees',
                'type' => 2,
            ],
            1140 => [
                'name' => 'Add',
                'route' => 'fees.fees-invoice-store',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1141 => [
                'name' => 'View Payment',
                'route' => 'fees.fees-view-payment',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1142 => [
                'name' => 'View',
                'route' => 'fees.fees-invoice-view',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1143 => [
                'name' => 'print',
                'route' => 'fees.fees-invoice-print',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1144 => [
                'name' => 'Add Payment',
                'route' => 'fees.add-fees-payment',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1145 => [
                'name' => 'Edit',
                'route' => 'fees.fees-invoice-edit',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1146 => [
                'name' => 'Delete',
                'route' => 'fees.fees-invoice-delete',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1147 => [
                'name' => 'Fees Collect',
                'route' => 'fees.fees-payment-store',
                'parent_route' => 'fees.fees-invoice',
                'type' => 3,
            ],
            1148 => [
                'name' => 'Bank Payment',
                'route' => 'fees.bank-payment',
                'parent_route' => 'fees',
                'type' => 2,
            ],
            1149 => [
                'name' => 'Search',
                'route' => 'fees.search-bank-payment',
                'parent_route' => 'fees.bank-payment',
                'type' => 3,
            ],
            1150 => [
                'name' => 'Approve Payment',
                'route' => 'fees.approve-bank-payment',
                'parent_route' => 'fees.bank-payment',
                'type' => 3,
            ],
            1151 => [
                'name' => 'Reject Payment',
                'route' => 'fees.reject-bank-payment',
                'parent_route' => 'fees.bank-payment',
                'type' => 3,
            ],
            1152 => [
                'name' => 'Fees Invoice Settings',
                'route' => 'fees.fees-invoice-settings',
                'parent_route' => 'fees',
                'type' => 2,
            ],
            1153 => [
                'name' => 'Update',
                'route' => 'fees.fees-invoice-settings-update',
                'parent_route' => 'fees',
                'type' => 3,
            ],
            1154 => [
                'name' => 'Report',
                'route' => 'fees.fees-report',
                'parent_route' => 'fees',
                'type' => 2,
            ],
            1155 => [
                'name' => 'Fees Due',
                'route' => 'fees.due-fees',
                'parent_route' => 'fees.fees-report',
                'type' => 3,
            ],
            1158 => [
                'name' => 'Fine Report',
                'route' => 'fees.fine-report',
                'parent_route' => 'fees.fees-report',
                'type' => 3,
            ],
            1159 => [
                'name' => 'Payment Report',
                'route' => 'fees.payment-report',
                'parent_route' => 'fees.fees-report',
                'type' => 3,
            ],
            1160 => [
                'name' => 'Balance Report',
                'route' => 'fees.balance-report',
                'parent_route' => 'fees.fees-report',
                'type' => 3,
            ],
            1161 => [
                'name' => 'Waiver Report',
                'route' => 'fees.waiver-report',
                'parent_route' => 'fees.fees-report',
                'type' => 3,
            ],
            1162 => [
                'name' => 'Fees Invoice',
                'route' => '',
                'parent_route' => 'bulk_print',
                'type' => 2,
            ],

            2200 => [
                'name' => 'Preloader Setting',
                'route' => 'setting.preloader',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            3100 => [
                'name' => 'ExamPlan',
                'route' => 'examplan',
                'parent_route' => null,
                'type' => 1,
            ],
            3101 => [
                'name' => 'Admit Card',
                'route' => 'examplan.admitcard.index',
                'parent_route' => 'examplan',
                'type' => 2,
            ],
            3102 => [
                'name' => 'Setting',
                'route' => 'examplan.admitcard.setting',
                'parent_route' => 'examplan',
                'type' => 3,
            ],
            3103 => [
                'name' => 'Generate',
                'route' => 'examplan.admitcard.generate',
                'parent_route' => 'examplan.admitcard.index',
                'type' => 3,
            ],
            3104 => [
                'name' => 'Save',
                'route' => '',
                'parent_route' => '',
                'type' => 3,
            ],
            3105 => [
                'name' => 'Seat Plan',
                'route' => 'examplan.seatplan.index',
                'parent_route' => 'examplan',
                'type' => 2,
            ],
            3106 => [
                'name' => 'Seat Plan Setting',
                'route' => 'examplan.seatplan.setting',
                'parent_route' => 'examplan',
                'type' => 3,
            ],
            3107 => [
                'name' => 'Generate',
                'route' => 'examplan.seatplan.generate',
                'parent_route' => 'examplan.seatplan.index',
                'type' => 3,
            ],
            3214 => [
                'name' => 'MarkSheet Report',
                'route' => 'custom-marksheet-report',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            3215 => [
                'name' => 'Print',
                'route' => 'percent-marksheet-print',
                'parent_route' => 'custom-marksheet-report',
                'type' => 3,
            ],
            3216 => [
                'name' => 'Subject Mark Sheet',
                'route' => 'exam_schedule',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            3217 => [
                'name' => 'Print',
                'route' => 'exam_schedule_print',
                'parent_route' => 'exam_schedule',
                'type' => 3,
            ],
            3218 => [
                'name' => 'Final Mark Sheet',
                'route' => 'exam_attendance',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            3219 => [
                'name' => 'Print',
                'route' => '',
                'parent_route' => 'exam_attendance',
                'type' => 3,
            ],
            3220 => [
                'name' => 'Student Final Mark Sheet',
                'route' => 'marks_register',
                'parent_route' => 'examination',
                'type' => 2,
            ],
            3221 => [
                'name' => 'Print',
                'route' => '',
                'parent_route' => 'marks_register',
                'type' => 3,
            ],
            4000 => [
                'name' => 'Utilities',
                'route' => 'utility',
                'parent_route' => 'system_settings',
                'type' => 2,
            ],
            5000 => [
                'name' => 'Position Setup',
                'route' => 'exam-report-position',
                'parent_route' => '',
                'type' => 2,
            ],

            15201 => [
                'name' => 'Multi Class Student',
                'route' => 'student.multi-class-student',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            15205 => [
                'name' => 'Delete Student Record',
                'route' => 'student.delete-student-record',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
            15209 => [
                'name' => 'UnAssign Student',
                'route' => 'unassigned_student',
                'parent_route' => 'student_info',
                'type' => 2,
            ],
        ];
    }
}
