<?php

namespace App\Http\Middleware;

use Closure;
use App\SmCustomLink;
use App\SmSocialMediaIcon;
use Illuminate\Support\Str;
use App\SmHeaderMenuManager;
use App\SmFrontendPersmission;
use Spatie\Valuestore\Valuestore;
use Illuminate\Support\Facades\Session;

class SubdomainMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $school = SaasSchool();
        Session::put('domain', $school->domain);
        app()->forgetInstance('school');
        app()->instance('school', $school);

        $settings_prefix = Str::lower(str_replace(' ', '_', $school->domain));
        $chat_settings = storage_path('app/chat/'.$settings_prefix.'_settings.json');
        if (! file_exists($chat_settings)) {
            copy(storage_path('app/chat/default_settings.json'), $chat_settings);
        }

        app()->scoped('general_settings', function () use ($chat_settings): Valuestore {
            return Valuestore::make($chat_settings);
        });

        view()->composer('frontEnd.home.front_master', function ($view) use ($school): void {

            if (activeTheme() && activeTheme() == 'edulia') {
                $menus = SmHeaderMenuManager::when(activeTheme(), function ($q): void {
                    $q->where('theme', activeTheme());
                })->when(activeTheme() == null, function ($q): void {
                    $q->where('theme', 'default');
                })->whereNull('parent_id')->where('school_id', app('school')->id)->orderBy('position')->get();
            } else {
                $menus = SmHeaderMenuManager::where('theme', 'default')->whereNull('parent_id')->where('school_id', app('school')->id)->orderBy('position')->get();
            }

            $data = [
                'social_permission' => SmFrontendPersmission::where('name', 'Social Icons')->where('parent_id', 1)->where('is_published', 1)->where('school_id', app('school')->id)->first(),
                'menus' => $menus,
                'custom_link' => SmCustomLink::where('school_id', app('school')->id)->first(),
                'social_icons' => SmSocialMediaIcon::where('school_id', app('school')->id)->where('status', 1)->get(),
                'school' => $school,
            ];

            $view->with($data);

        });

        config(['broadcasting.default' => saasEnv('chatting_method')]);
        config(['broadcasting.connections.pusher.key' => saasEnv('pusher_app_key')]);
        config(['broadcasting.connections.pusher.secret' => saasEnv('pusher_app_secret')]);
        config(['broadcasting.connections.pusher.app_id' => saasEnv('pusher_app_id')]);
        config(['broadcasting.connections.pusher.options.cluster' => saasEnv('pusher_app_cluster')]);

        return $next($request);
    }
}
