<?php

namespace App;

use App\Scopes\ActiveStatusSchoolScope;
use App\Scopes\SchoolScope;
use App\Scopes\StatusAcademicSchoolScope;
use Exception;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class SmClassRoutineUpdate extends Model
{
    use HasFactory;

    public static function assingedClassRoutine($class_time, $day, $class_id, $section_id)
    {
        try {

            return self::where('class_period_id', $class_time)
                ->where('day', $day)
                ->where('class_id', $class_id)->where('section_id', $section_id)
                ->first();
        } catch (Exception $exception) {
            return [];
        }
    }

    public static function teacherAssingedClassRoutine($class_time, $day, $teacher_id)
    {
        try {
            return self::where('class_period_id', $class_time)->where('day', $day)->where('class_period_id', $class_time)->where('academic_id', getAcademicId())->where('school_id', Auth::user()->school_id)->where('teacher_id', $teacher_id)->first();
        } catch (Exception $exception) {
            return [];
        }
    }

    public function subject()
    {
        return $this->belongsTo(SmSubject::class, 'subject_id', 'id')->withDefault();
    }

    public function subjectApi()
    {
        return $this->belongsTo(SmSubject::class, 'subject_id', 'id')->withoutGlobalScope(StatusAcademicSchoolScope::class)->withDefault();
    }

    public function saasSubject()
    {
        return $this->belongsTo(SmSubject::class, 'subject_id', 'id')->withoutGlobalScope(StatusAcademicSchoolScope::class)->withDefault();
    }

    public function class()
    {
        return $this->belongsTo(SmClass::class, 'class_id', 'id');
    }

    public function classApi()
    {
        return $this->belongsTo(SmClass::class, 'class_id', 'id')->withOutGlobalScope(StatusAcademicSchoolScope::class);
    }

    public function classRoom()
    {
        return $this->belongsTo(SmClassRoom::class, 'room_id', 'id')->withDefault();
    }

    public function classRoomApi()
    {
        return $this->belongsTo(SmClassRoom::class, 'room_id', 'id')->withDefault()->withOutGlobalScope(ActiveStatusSchoolScope::class);
    }

    public function teacherDetail()
    {
        return $this->belongsTo(SmStaff::class, 'teacher_id', 'id')->withDefault();
    }

    public function teacherDetailApi()
    {
        return $this->belongsTo(SmStaff::class, 'teacher_id', 'id')->withOutGlobalScope(ActiveStatusSchoolScope::class)->withDefault();
    }

    public function section()
    {
        return $this->belongsTo(SmSection::class, 'section_id', 'id');
    }

    public function sectionApi()
    {
        return $this->belongsTo(SmSection::class, 'section_id', 'id')->withOutGlobalScope(StatusAcademicSchoolScope::class);
    }

    public function classTime()
    {
        return $this->belongsTo(SmClassTime::class, 'class_period_id');
    }

    public function saasClassTime()
    {
        return $this->belongsTo(SmClassTime::class, 'class_period_id');
    }

    public function weekend()
    {
        return $this->belongsTo(SmWeekend::class, 'day');
    }

    public function weekendApi()
    {
        return $this->belongsTo(SmWeekend::class, 'day')->withOutGlobalScope(SchoolScope::class);
    }

    public function unSession()
    {
        return $this->belongsTo(\Modules\University\Entities\UnSession::class, 'un_session_id', 'id')->withDefault();
    }

    public function unFaculty()
    {
        return $this->belongsTo(\Modules\University\Entities\UnFaculty::class, 'un_faculty_id', 'id')->withDefault();
    }

    public function unDepartment()
    {
        return $this->belongsTo(\Modules\University\Entities\UnDepartment::class, 'un_department_id', 'id')->withDefault();
    }

    public function unAcademic()
    {
        return $this->belongsTo(\Modules\University\Entities\UnAcademicYear::class, 'un_academic_id', 'id')->withDefault();
    }

    public function unSemester()
    {
        return $this->belongsTo(\Modules\University\Entities\UnSemester::class, 'un_semester_id', 'id')->withDefault();
    }

    public function unSemesterLabel()
    {
        return $this->belongsTo(\Modules\University\Entities\UnSemesterLabel::class, 'un_semester_label_id', 'id')
            ->withDefault();
    }

    public function unSubject()
    {
        return $this->belongsTo(\Modules\University\Entities\UnSubject::class, 'un_subject_id', 'id')->withDefault();
    }

    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new StatusAcademicSchoolScope);
    }
}
