<?php

namespace App\View\Components;

use App\SmParent;
use App\SmStudent;
use Illuminate\View\Component;
use App\Traits\SidebarDataStore;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Modules\MenuManage\Entities\Sidebar;
use Modules\RolePermission\Entities\Permission;
use Modules\MenuManage\Entities\AlternativeModule;
use Modules\MenuManage\Entities\PermissionSection;
use Modules\RolePermission\Entities\AssignPermission;

class SidebarComponent extends Component
{
    use SidebarDataStore;

    public function __construct()
    {
        //
    }

    public function render()
    {
        $data = [];

        $data['paid_modules'] = $this->allActivePaidModules();

        if (auth()->check() && auth()->user()->role_id == 3) {
            $parent = SmParent::where('user_id',auth()->id())->first();
            $childrens = SmStudent::where('parent_id',$parent->id)->get();
            
            $data['children'] =  $childrens;
           
        }

        return view('components.sidebar-component', $data);
    }
}
