@extends('backEnd.master')
@section('title')
    @lang('study.upload_content_list')
@endsection
@section('mainContent')
    <section class="sms-breadcrumb mb-20">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1>@lang('study.upload_content_list')</h1>
                <div class="bc-pages">
                    <a href="{{ route('dashboard') }}">@lang('common.dashboard')</a>
                    <a href="#">@lang('study.study_material')</a>
                    <a href="#">@lang('study.upload_content_list')</a>
                </div>
            </div>
        </div>
    </section>
    <section class="admin-visitor-area up_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                @if(userPermission('save-upload-content') || isset($editData))
                <div class="col-lg-4 col-xl-3">
                    <div class="row">
                        <div class="col-lg-12">
                            @if (isset($editData))
                                {{ html()->form('POST', route('update-upload-content', @$editData->id))->attribute('class', 'form-horizontal')->attribute('enctype', 'multipart/form-data')->attribute('files', true)->open() }}
                                <input type="hidden" name="id" value="{{ @$editData->id }}">
                            @else
                                @if (userPermission('save-upload-content'))
                                    {{ html()->form('POST', route('save-upload-content'))->attribute('class', 'form-horizontal')->attribute('enctype', 'multipart/form-data')->attribute('files', true)->open() }}
                                @endif
                            @endif
                            <div class="white-box">
                                <div class="main-title">
                                    <h3 class="mb-15">
                                        @if (isset($editData))
                                            @lang('study.edit_upload_content')
                                        @else
                                            @lang('study.upload_content')
                                        @endif

                                    </h3>
                                </div>
                                <div class="add-visitor">
                                    <div class="row mb-25">
                                        <div class="col-lg-12 mb-30">
                                            <div class="primary_input">
                                                <label> @lang('study.content_title') <span class="text-danger"> *</span> </label>
                                                <input
                                                    class="primary_input_field form-control{{ $errors->has('content_title') ? ' is-invalid' : '' }}"
                                                    type="text" name="content_title" autocomplete="off"
                                                    value="{{ isset($editData) ? @$editData->content_title : old('content_title') }}">


                                                @if ($errors->has('content_title'))
                                                    <span class="text-danger">
                                                        {{ $errors->first('content_title') }}
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-lg-12 mb-30">
                                            <label class="primary_input_label" for="">
                                                {{ __('study.content_type') }}
                                                <span class="text-danger"> *</span>
                                            </label>
                                            <select
                                                class="primary_select form-control{{ $errors->has('content_type') ? ' is-invalid' : '' }}"
                                                name="content_type" id="content_type">
                                                <option data-display="@lang('study.content_type') *" value="">
                                                    @lang('study.content_type') *
                                                </option>
                                                <option value="as"
                                                    {{ (old('content_type') == 'as') ? 'selected' : (isset($editData) && @$editData->content_type == 'as' ? 'selected' : '') }}>
                                                    @lang('study.assignment')
                                                </option>
                                                {{-- <option value="st">@lang('study.study_material')</option> --}}
                                                <option value="sy"
                                                    {{ (old('content_type') == 'sy') ? 'selected' : (isset($editData) && @$editData->content_type == 'sy' ? 'selected' : '') }}>
                                                    @lang('study.syllabus')
                                                </option>
                                                <option value="ot"
                                                    {{ (old('content_type') == 'ot') ? 'selected' : (isset($editData) && @$editData->content_type == 'ot' ? 'selected' : '') }}>
                                                    @lang('study.other_download')
                                                </option>
                                            </select>

                                            @if ($errors->has('content_type'))
                                                <span class="text-danger invalid-select" role="alert">
                                                    {{ $errors->first('content_type') }}
                                                </span>
                                            @endif
                                        </div>
                                        <div class="col-lg-12">
                                            <label class="primary_input_label" for="">@lang('study.available_for')<span class="text-danger"> *</span></label><br>

                                            <div class="">
                                                <input type="checkbox" id="all_admin" class="common-checkbox form-control"
                                                    name="available_for[]" value="admin"
                                                    @if( old('available_for') )
                                                        {{ in_array('admin', old('available_for')) ? 'checked' : '' }}
                                                    @else
                                                        {{ isset($editData) && @$editData->available_for_admin == '1' ? 'checked' : '' }}
                                                    @endif
                                                >
                                                <label style="top: 50% !important;" for="all_admin">@lang('study.all_admin')</label>
                                            </div>

                                            <div class="">
                                                <input type="checkbox" id="student" class="common-checkbox form-control"
                                                    name="available_for[]" value="student"
                                                    @if( old('available_for') )
                                                        {{ in_array('student', old('available_for')) ? 'checked' : '' }}
                                                    @else
                                                        {{ (isset($editData) && @$editData->available_for_all_classes == '1') || @$editData->un_semester_label_id != '' || @$editData->class != '' || @$editData->section != '' ? 'checked' : '' }}
                                                    @endif
                                                >
                                                <label for="student">@lang('common.student')</label>
                                            </div>

                                            @if ($errors->has('available_for'))
                                                <span class="text-danger validate-textarea-checkbox" role="alert">
                                                    {{ $errors->first('available_for') }}
                                                </span>
                                            @endif
                                        </div>

                                        @php
                                            // if( @$editData->available_for_all_classes == "1" || @$editData->class != "" || @$editData->section != ""){
                                            if (@$editData->available_for_all_classes == '1') {
                                                $show = '';
                                                $show1 = 'disabledbutton';
                                            } elseif (@$editData->class != '' || @$editData->section != '') {
                                                $show = 'disabledbutton';
                                                $show1 = '';
                                            } else {
                                                $show = 'disabledbutton';
                                                $show1 = 'disabledbutton';
                                            }
                                        @endphp
                                        @if (!moduleStatusCheck('University'))
                                            <div class="col-lg-12 {{ @$show }} mb-30" id="availableClassesDiv">

                                                <div class="">
                                                    <input type="checkbox" id="all_classes"
                                                        class="common-checkbox form-control" name="all_classes"
                                                        {{ isset($editData) && @$editData->available_for_all_classes == '1' ? 'checked' : '' }}>
                                                    <label for="all_classes">@lang('study.available_for_all_classes')</label>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="forStudentWrapper col-lg-12 mb-20 {{ $errors->has('class') || $errors->has('section') ? '' : @$show1 }}"
                                            id="contentDisabledDiv">
                                            @if (moduleStatusCheck('University'))
                                                @includeIf(
                                                    'university::common.session_faculty_depart_academic_semester_level',
                                                    [
                                                        'required' => ['USN', 'UF', 'UD', 'US', 'USL'],
                                                        'hide' => ['USUB', 'UA'],
                                                        'row' => 1,
                                                        'div' => 'col-lg-12',
                                                        'mt' => 'mt-0',
                                                    ]
                                                )
                                                <input type="hidden" name="un_academic_id" id="select_academic"
                                                    value="{{ getAcademicId() }}">
                                            @else
                                                <div class="row">
                                                    @include('backEnd.common.search_criteria', [
                                                        'div' => shiftEnable() ? 'col-lg-12' : 'col-lg-12',
                                                        'mt' => 'mt-20',
                                                        'visiable' => ['shift', 'class', 'section'],
                                                        'title' => ['class', 'section','shift'],
                                                        'class_name' => 'class',
                                                        'section_name' => 'section',
                                                        'selected' => [
                                                            'shift_id' => @$editData->shift_id,
                                                            'class_id' => @$editData->class,
                                                            'section_id' => @$editData->section,
                                                        ],
                                                    ])
                                                </div>

                                            @endif

                                        </div>
                                        <input type="hidden" name="url" id="url"
                                            value="{{ URL::to('/') }}">
                                    </div>
                                    <div class="row  mb-20">
                                        <div class="col-lg-12">
                                            <div class="primary_input">
                                                <label class="primary_input_label" for="">@lang('common.date')
                                                    <span class="text-danger">*</span> </label>
                                                <div class="primary_datepicker_input">
                                                    <div class="no-gutters input-right-icon">
                                                        <div class="col">
                                                            <div class="">
                                                                <input
                                                                    class="primary_input_field  primary_input_field date form-control form-control{{ $errors->has('upload_date') ? ' is-invalid' : '' }}"
                                                                    id="upload_date" type="text" name="upload_date"
                                                                    value="{{ isset($editData) ? date('m/d/Y', strtotime(@$editData->upload_date)) : date('m/d/Y') }}">
                                                            </div>
                                                        </div>
                                                        <button class="btn-date" data-id="#upload_date" type="button">
                                                            <label class="m-0 p-0" for="upload_date">
                                                                <i class="ti-calendar" id="start-date-icon"></i>
                                                            </label>
                                                        </button>
                                                    </div>
                                                </div>
                                                <span class="text-danger">{{ $errors->first('upload_date') }}</span>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="row mb-20">
                                        <div class="col-lg-12">
                                            <div class="primary_input">
                                                <label class="primary_input_label" for="">@lang('study.description')
                                                    <span></span> </label>
                                                <textarea class="primary_input_field form-control" cols="0" rows="3" name="description"
                                                    id="description">{{ isset($editData) ? @$editData->description : old('description') }}</textarea>


                                            </div>
                                        </div>
                                    </div>


                                    <div class="row no-gutters input-right-icon mb-20">
                                        <div class="col-lg-12">
                                            <div class="primary_input">
                                                <label> @lang('study.source_url')</label>
                                                <input
                                                    class="primary_input_field form-control{{ $errors->has('source_url') ? ' is-invalid' : '' }}"
                                                    type="text" name="source_url" autocomplete="off"
                                                    value="{{ isset($editData) ? @$editData->source_url : old('source_url') }}">


                                                @if ($errors->has('source_url'))
                                                    <span class="text-danger">
                                                        {{ $errors->first('source_url') }}
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mb-20">
                                        <div class="col-lg-12 mt-15">
                                            <div class="primary_input">
                                                <div class="primary_file_uploader">
                                                    <input
                                                        class="primary_input_field form-control {{ $errors->has('content_file') ? ' is-invalid' : '' }}"
                                                        readonly="true" type="text"
                                                        placeholder="{{ isset($editData->upload_file) && @$editData->upload_file != '' ? getFilePath3(@$editData->upload_file) : trans('study.file') . '' }}"
                                                        id="placeholderUploadContent">
                                                    <button class="" type="button">
                                                        <label class="primary-btn small fix-gr-bg"
                                                            for="upload_content_file">{{ __('common.browse') }}</label>
                                                        <input type="file" class="d-none" name="content_file"
                                                            id="upload_content_file">
                                                    </button>
                                                    <code>(jpg,png,jpeg,pdf,doc,docx,mp4,mp3,txt are allowed for
                                                        upload)</code>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @php
                                        $tooltip = '';
                                        if (userPermission('save-upload-content')) {
                                            @$tooltip = '';
                                        } else {
                                            @$tooltip = 'You have no permission to add';
                                        }
                                    @endphp
                                    <div class="row mt-40">
                                        <div class="col-lg-12 text-center">
                                            <button class="primary-btn fix-gr-bg" data-toggle="tooltip"
                                                title="{{ @$tooltip }}">
                                                <span class="ti-check"></span>
                                                @if (isset($editData))
                                                    @lang('common.update')
                                                @else
                                                    @lang('common.save')
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{ html()->form()->close() }}
                        </div>
                    </div>
                </div>
                @endif
                <div class="@if(userPermission('save-upload-content') || isset($editData)) col-lg-8 col-xl-9 @else col-lg-12 @endif">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-lg-4 no-gutters">
                                <div class="main-title">
                                    <h3 class="mb-15"> @lang('study.upload_content_list')</h3>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <x-table>
                                    <table id="table_id" class="table data-table" cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th>@lang('common.sl')</th>
                                                <th> @lang('study.content_title')</th>
                                                <th> @lang('common.type')</th>
                                                <th> @lang('common.date')</th>
                                                <th> @lang('study.available_for')</th>
                                                @if (moduleStatusCheck('University'))
                                                    <th> @lang('university::un.semester_label')</th>
                                                @else
                                                    {{-- <th> @lang('study.classSec')</th> --}}
                                                    @if(shiftEnable())
                                                        <th>@lang('admin.class_Sec_shift')</th>   
                                                    @else
                                                        <th>@lang('admin.class_Sec')</th>   
                                                    @endif
                                                @endif
                                                <th> @lang('common.action')</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </x-table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- delete content modal start  --}}
    <div class="modal fade admin-query" id="deleteUpContentModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">@lang('study.delete_upload_content')</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        &times;
                    </button>
                </div>

                <div class="modal-body">
                    <div class="text-center">
                        <h4>@lang('common.are_you_sure_to_delete')</h4>
                    </div>

                    <div class="mt-40 d-flex justify-content-between">
                        <button type="button" class="primary-btn tr-bg" data-dismiss="modal">@lang('common.cancel')</button>
                        {{ html()->form('POST', route('delete-upload-content'))->open() }}
                        <input type="hidden" name="id" value="">
                        <button class="primary-btn fix-gr-bg" type="submit">@lang('common.delete')</button>
                        {{ html()->form()->close() }}
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>

    {{-- delete content modal end  --}}
@endsection

@include('backEnd.partials.date_picker_css_js')

@include('backEnd.partials.data_table_js')
@include('backEnd.partials.server_side_datatable')
@push('script')
    <script>
        $(document).ready(function() {
            $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                "ajax": $.fn.dataTable.pipeline({
                    url: "{{ route('upload-content-list-datatable') }}",
                    data: {},
                    pages: "{{ generalSetting()->ss_page_load }}" // number of pages to cache

                }),
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'id',
                        orderable: true
                    },
                    {
                        data: 'content_title',
                        name: 'content_title',
                        orderable: true
                    },
                    {
                        data: 'type',
                        name: 'type',
                        orderable: false
                    },
                    {
                        data: 'upload_date',
                        name: 'upload_date',
                        orderable: true
                    },
                    {
                        data: 'avaiable',
                        name: 'avaiable',
                        orderable: false
                    },
                    {
                        data: 'class_sections',
                        name: 'class_sections',
                        orderable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: true
                    },
                ],
                bLengthChange: false,
                bDestroy: true,
                order: [
                    [1, 'asc']
                ],
                language: {
                    search: "<i class='ti-search'></i>",
                    searchPlaceholder: window.jsLang('quick_search'),
                    paginate: {
                        next: "<i class='ti-arrow-right'></i>",
                        previous: "<i class='ti-arrow-left'></i>",
                    },
                },
                dom: "Bfrtip",
                buttons: [{
                        extend: "copyHtml5",
                        text: '<i class="fa fa-files-o"></i>',
                        title: $("#logo_title").val(),
                        titleAttr: window.jsLang('copy_table'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "excelHtml5",
                        text: '<i class="fa fa-file-excel-o"></i>',
                        titleAttr: window.jsLang('export_to_excel'),
                        title: $("#logo_title").val(),
                        margin: [10, 10, 10, 0],
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "csvHtml5",
                        text: '<i class="fa fa-file-text-o"></i>',
                        titleAttr: window.jsLang('export_to_csv'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "pdfHtml5",
                        text: '<i class="fa fa-file-pdf-o"></i>',
                        title: $("#logo_title").val(),
                        titleAttr: window.jsLang('export_to_pdf'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                        orientation: "landscape",
                        pageSize: "A4",
                        margin: [0, 0, 0, 12],
                        alignment: "center",
                        header: true,
                        customize: function(doc) {
                            doc.content[1].margin = [100, 0, 100, 0]; //left, top, right, bottom
                            doc.content.splice(1, 0, {
                                margin: [0, 0, 0, 12],
                                alignment: "center",
                                image: "data:image/png;base64," + $("#logo_img").val(),
                            });
                            doc.defaultStyle = {
                                font: 'DejaVuSans'
                            }
                        },
                    },
                    {
                        extend: "print",
                        text: '<i class="fa fa-print"></i>',
                        titleAttr: window.jsLang('print'),
                        title: $("#logo_title").val(),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "colvis",
                        text: '<i class="fa fa-columns"></i>',
                        postfixButtons: ["colvisRestore"],
                    },
                ],
                columnDefs: [{
                    visible: false,
                }, ],
                responsive: true,
            });
        });
    </script>
    <script>
        function deleteUpContent(id) {
            var modal = $('#deleteUpContentModal');
            modal.find('input[name=id]').val(id)
            modal.modal('show');
        }
    </script>
@endpush
