
<title><?php echo e(__('edulia.blog_list')); ?> </title>
<?php $__env->startSection(config('pagebuilder.site_section')); ?>
<?php echo e(headerContent()); ?>

<?php
    $gs = generalSetting();
?>
    <section class="bradcrumb_area">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="bradcrumb_area_inner">
                        <h1>
                            <?php echo e(__('edulia.blog_list')); ?> 
                            <span>
                                <a href="<?php echo e(url('/')); ?>"><?php echo e(__('edulia.home')); ?></a> /<?php echo e(__('edulia.blog_list')); ?>

                            </span>
                        </h1>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="section_padding blog">
        <?php if(!$blogs && auth()->check() && auth()->user()->role_id == 1): ?>
            <p class="text-center text-danger"><?php echo app('translator')->get('edulia.no_data_available_please_go_to'); ?> <a target="_blank"
                    href="<?php echo e(route('news_index')); ?>"><?php echo app('translator')->get('edulia.add_blog'); ?></a></p>
        <?php elseif($blogs->count() > 0): ?>
            <div class="container">
                <div class="row">
                    <div class="col-lg-10 offset-lg-1 col-md-12">
                        <div class="blog_card">
                            <div class="row">
                                <div class="col-lg-8 col-md-7" id="dynamicLoadMoreData">
                                    <?php $__currentLoopData = $blogs->paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="blog_card_wrapper searchBlogContent">
                                            <div class="blog_card_wrapper_img">
                                                <img src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($item->news_title); ?>">
                                            </div>
                                            <div class="blog_card_wrapper_content">
                                                <a href="<?php echo e(route('frontend.news-details', $item->id)); ?>" class='blog_card_wrapper_content_title'><?php echo e($item->news_title); ?></a>
                                                <p class="blog_card_wrapper_content_meta"><?php echo e(dateConvert($item->publish_date)); ?> / <?php echo e($item->category->category_name); ?></p>
                                                <p><?php echo e(Str::limit(strip_tags($item->news_body), 232, '...')); ?></p>
                                                <a href="<?php echo e(route('frontend.news-details', $item->id)); ?>"><?php echo e(__('edulia.read_more')); ?></a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php if($gs->blog_search == 1 || $gs->recent_blog == 1): ?>
                                    <div class="col-lg-4 col-md-5">
                                        <div class="blog_widget">
                                            <?php if($gs->blog_search == 1): ?>
                                                <div class="blog_widget_search">
                                                    <label for="#" class='blog_widget_search_icon'><i class="far fa-search"></i></label>
                                                    <input type="text" class="input-control-input" placeholder='<?php echo e(__('edulia.search')); ?>' id="blogallcontentsearch">
                                                </div>
                                            <?php endif; ?>
                                            <?php if($gs->recent_blog == 1): ?>
                                                <div class="blog_widget_item">
                                                    <h5><?php echo e(__('edulia.recent_blog')); ?></h5>
                                                    <?php $__currentLoopData = $blogs->orderBy('id', 'desc')->paginate(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="blog_widget_item_recentnews">
                                                            <a href="<?php echo e(route('frontend.news-details', $blog->id)); ?>"><?php echo e($blog->news_title); ?></a>
                                                            <p><?php echo e(dateConvert($blog->publish_date)); ?> / <?php echo e($blog->category->category_name); ?></p>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>                                
                                <?php if($blogs->count() > 5): ?>
                                    <div class="row text-center">
                                        <div class="col-md-12">
                                            <div class="load_more section_padding_top">
                                                <a href="#" class="site_btn load_more_blog_btn"><?php echo e(__('edulia.load_more')); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <p class="text-center text-danger"><?php echo app('translator')->get('edulia.no_data_available'); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </section>
<?php echo e(footerContent()); ?>

<?php $__env->stopSection(); ?>
<?php if (! $__env->hasRenderedOnce('c855a542-f511-4ea9-bff8-1aee6c01434f')): $__env->markAsRenderedOnce('c855a542-f511-4ea9-bff8-1aee6c01434f');
$__env->startPush(config('pagebuilder.site_script_var')); ?>
    <script>
        $("#blogallcontentsearch").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $(".searchBlogContent").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });

        $(document).on('click', '.load_more_blog_btn', function (e) {
            e.preventDefault();
            var totalBlog = $('.searchBlogContent').length;
            $.ajax({
                url: "<?php echo e(route('frontend.load-more-blog-list')); ?>",
                method: "POST",
                data: {
                    skip: totalBlog,
                    _token: "<?php echo e(csrf_token()); ?>",
                },
                success: function (response) {
                    if (response.success) {
                        $('#dynamicLoadMoreData').append(response.html);

                        if (totalBlog + response.loaded_data_count >= response.total_data) {
                            $('.load_more_blog_btn').hide();
                        }
                    } else {
                        $('.load_more_blog_btn').hide();
                    }
                },
                error: function () {
                    alert("An error occurred while loading more blogs.");
                }
            });
        });

    </script>
<?php $__env->stopPush(); endif; ?>

<?php echo $__env->make(config('pagebuilder.site_layout'), ['edit' => false], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ezzypocketschool/public_html/resources/views/frontEnd/theme/edulia/blog_list.blade.php ENDPATH**/ ?>