
<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('student.student_list'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
<style>
      .dataTables_length label{
        display: flex;
        align-items: center;
        gap: 10px;
    }
  
    .dataTables_length select {
        height: 37px;
        width: 55px;
        border-radius: 4px;
        border: 1px solid #f1f1f1;
        padding: 0px 5px;
        color: var(--base_color);
    }
</style>
    <section class="sms-breadcrumb mb-20 up_breadcrumb">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1><?php echo app('translator')->get('student.manage_student'); ?></h1>
                <div class="bc-pages">
                    <a href="<?php echo e(route('dashboard')); ?>"><?php echo app('translator')->get('common.dashboard'); ?></a>
                    <a href="#"><?php echo app('translator')->get('student.student_information'); ?></a>
                    <a href="#"><?php echo app('translator')->get('student.student_list'); ?></a>
                </div>
            </div>
        </div>
    </section>
    <section class="admin-visitor-area up_admin_visitor">
        <div class="container-fluid p-0">
            <?php echo e(html()->form('POST', route('student-list-search'))->attributes([
                    'class' => 'form-horizontal',
                    'enctype' => 'multipart/form-data',
                    'files' => true,
                    'id' => 'infix_form',
                ])->open()); ?>

            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box filter_card">
                        <div class="row">
                            <div class="col-lg-8 col-md-6 col-sm-6">
                                <div class="main-title mt_0_sm mt_0_md">
                                    <h3 class="mb-15"><?php echo app('translator')->get('common.select_criteria'); ?></h3>
                                </div>
                            </div>

                            <?php if(userPermission('student_store')): ?>
                                <div class="col-lg-4 col-md-6 col-sm-6 text-left text-sm-right mb-4 mb-sm-0">
                                    <a href="<?php echo e(route('student_admission')); ?>" class="primary-btn small fix-gr-bg">
                                        <span class="ti-plus pr-2"></span>
                                        <?php echo app('translator')->get('student.add_student'); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            
                        </div>
                        <div class="row row-gap-24">
                            <input type="hidden" name="url" id="url" value="<?php echo e(URL::to('/')); ?>">


                            <?php if(moduleStatusCheck('University')): ?>
                                <?php if ($__env->exists(
                                    'university::common.session_faculty_depart_academic_semester_level',
                                    ['mt' => 'mt-30', 'hide' => ['USUB'], 'required' => ['USEC']]
                                )) echo $__env->make(
                                    'university::common.session_faculty_depart_academic_semester_level',
                                    ['mt' => 'mt-30', 'hide' => ['USUB'], 'required' => ['USEC']]
                                , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                <div class="col-lg-4 col-md-6 mt-25">
                                    <div class="primary_input ">
                                        <input class="primary_input_field" type="text" placeholder="Name" name="name"
                                            value="<?php echo e(isset($name) ? $name : ''); ?>">
                                        <label class="primary_input_label" for=""><?php echo app('translator')->get('student.search_by_name'); ?></label>

                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 mt-25">
                                    <div class="primary_input md_mb_20">
                                        <label class="primary_input_label" for=""><?php echo app('translator')->get('student.search_by_roll_no'); ?></label>
                                        <input class="primary_input_field" type="text" placeholder="Roll" name="roll_no"
                                            value="<?php echo e(isset($roll_no) ? $roll_no : ''); ?>">

                                    </div>
                                </div>
                            <?php else: ?>
                                <?php echo $__env->make('backEnd.shift.shift_class_section_include', [
                                    'div' =>  'col-lg-4 col-md-6',
                                    'mt' => 'mt-0',
                                    'visiable' => ['academic_year', 'shift', 'class', 'section'],
                                    'required' => ['academic_year', 'class', 'section'],
                                    'title' => ['academic_year', 'class', 'section', 'shift'],
                                    'class_name' => 'class_id',
                                    'section_name' => 'section_id',
                                    'selected' => [
                                        'shift_id' => @$shift_id,
                                        'class_id' => @$class_id,
                                        'section_id' => @$section_id,
                                    ],
                                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                <div class="col-lg-4 col-md-6">
                                    <div class="primary_input sm_mb_20 ">
                                        <label class="primary_input_label" for=""><?php echo app('translator')->get('student.search_by_name'); ?></label>

                                        <input class="primary_input_field" type="text" placeholder="Name" name="name"
                                            value="<?php echo e(isset($name) ? $name : old('name')); ?>">

                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="primary_input sm_mb_20 ">
                                        <label class="primary_input_label" for=""><?php echo app('translator')->get('student.search_by_roll'); ?></label>
                                        <input class="primary_input_field" type="text" placeholder="Roll" name="roll_no"
                                            value="<?php echo e(isset($roll_no) ? $roll_no : old('roll_no')); ?>">


                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-lg-12 mt-20 text-right">
                                <button type="submit" class="primary-btn small fix-gr-bg" id="btnsubmit">
                                    <span class="ti-search pr-2"></span>
                                    <?php echo app('translator')->get('common.search'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" id="academic_id" value="<?php echo e(@$academic_year); ?>">
            <input type="hidden" id="class" value="<?php echo e(@$class_id); ?>">
            <input type="hidden" id="section" value="<?php echo e(@$section_id); ?>">
            <input type="hidden" id="shift_id" value="<?php echo e(@$shift_id); ?>">
            <input type="hidden" id="roll" value="<?php echo e(@$roll_no); ?>">
            <input type="hidden" id="name" value="<?php echo e(@$name); ?>">
            <input type="hidden" id="un_session" value="<?php echo e(@$data['un_session_id']); ?>">
            <input type="hidden" id="un_academic" value="<?php echo e(@$data['un_academic_id']); ?>">
            <input type="hidden" id="un_faculty" value="<?php echo e(@$data['un_faculty_id']); ?>">
            <input type="hidden" id="un_department" value="<?php echo e(@$data['un_department_id']); ?>">
            <input type="hidden" id="un_semester_label" value="<?php echo e(@$data['un_semester_label_id']); ?>">
            <input type="hidden" id="un_section" value="<?php echo e(@$data['un_section_id']); ?>">
            <?php echo e(html()->form()->close()); ?>

            
            <div class="row mt-40 full_wide_table">
                <div class="col-lg-12">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-lg-4 no-gutters">
                                <div class="main-title">
                                    <h3 class="mb-15"><?php echo app('translator')->get('student.student_list'); ?></h3>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <?php if (isset($component)) { $__componentOriginal163c8ba6efb795223894d5ffef5034f5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal163c8ba6efb795223894d5ffef5034f5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.table','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                    <table id="table_id"
                                        class="table data-table Crm_table_active3 no-footer dtr-inline collapsed"
                                        cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th><?php echo app('translator')->get('student.admission_no'); ?></th>
                                                <th><?php echo app('translator')->get('student.name'); ?></th>
                                                <?php if(!moduleStatusCheck('University') && generalSetting()->with_guardian): ?>
                                                    <th><?php echo app('translator')->get('student.father_name'); ?></th>
                                                <?php endif; ?>
                                                <th><?php echo app('translator')->get('student.date_of_birth'); ?></th>
                                                <?php if(moduleStatusCheck('University')): ?>
                                                    <th><?php echo app('translator')->get('university::un.semester_label'); ?></th>
                                                    <th><?php echo app('translator')->get('university::un.fac_dept'); ?></th>
                                                <?php else: ?>
                                                    <?php if(shiftEnable()): ?>
                                                        <th><?php echo app('translator')->get('admin.class_Sec_shift'); ?></th>   
                                                    <?php else: ?>
                                                        <th><?php echo app('translator')->get('admin.class_Sec'); ?></th>   
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                                <th><?php echo app('translator')->get('common.gender'); ?></th>
                                                <th><?php echo app('translator')->get('common.type'); ?></th>
                                                <th><?php echo app('translator')->get('common.phone'); ?></th>
                                                <th><?php echo app('translator')->get('common.actions'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal163c8ba6efb795223894d5ffef5034f5)): ?>
<?php $attributes = $__attributesOriginal163c8ba6efb795223894d5ffef5034f5; ?>
<?php unset($__attributesOriginal163c8ba6efb795223894d5ffef5034f5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal163c8ba6efb795223894d5ffef5034f5)): ?>
<?php $component = $__componentOriginal163c8ba6efb795223894d5ffef5034f5; ?>
<?php unset($__componentOriginal163c8ba6efb795223894d5ffef5034f5); ?>
<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </section>
    
    <div class="modal fade admin-query" id="deleteStudentModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('student.disable_student'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="text-center">
                        <h4><?php echo app('translator')->get('student.are_you_sure_to_disable'); ?></h4>
                    </div>
                    <div class="mt-40 d-flex justify-content-between">
                        <button type="button" class="primary-btn tr-bg" data-dismiss="modal"><?php echo app('translator')->get('common.cancel'); ?></button>
                        <?php echo e(html()->form('POST', route('student-delete'))->attributes([
                                'enctype' => 'multipart/form-data',
                            ])->open()); ?>

                        <input type="hidden" name="id" value="<?php echo e(@$student->id); ?>" id="student_delete_i">
                        
                        <button class="primary-btn fix-gr-bg" type="submit"><?php echo app('translator')->get('common.disable'); ?></button>
                        <?php echo e(html()->form()->close()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php
        if (isset($academic_year) || isset($class_id)) {
            $ajax_url = url(
                'student-list-datatable?academic_year=' .
                    $academic_year .
                    '&class=' .
                    $class_id .
                    '&section=' .
                    $section_id .
                    '&roll_no=' .
                    $roll_no .
                    '&name=' .
                    $name,
            );
        } else {
            $ajax_url = url('student-list-datatable');
        }
    ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backEnd.partials.data_table_js', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('backEnd.partials.server_side_datatable', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                "ajax": $.fn.dataTable.pipeline({
                    url: "<?php echo e(url('student-list-datatable')); ?>",
                    data: {
                        academic_year: $('#academic_id').val(),
                        class: $('#class').val(),
                        section: $('#section').val(),
                        shift_id: $('#shift_id').val(),
                        roll_no: $('#roll').val(),
                        name: $('#name').val(),
                        un_session_id: $('#un_session').val(),
                        un_academic_id: $('#un_academic').val(),
                        un_faculty_id: $('#un_faculty').val(),
                        un_department_id: $('#un_department').val(),
                        un_semester_label_id: $('#un_semester_label').val(),
                        un_section_id: $('#un_section').val(),
                    },
                    pages: "<?php echo e(generalSetting()->ss_page_load); ?>" // number of pages to cache
                }),
                columns: [{
                        data: 'admission_no',
                        name: 'admission_no'
                    },
                    {
                        data: 'full_name',
                        name: 'full_name'
                    },
                    <?php if(!moduleStatusCheck('University') && generalSetting()->with_guardian): ?>
                        {
                            data: 'parents.fathers_name',
                            name: 'parents.fathers_name'
                        },
                    <?php endif; ?> {
                        data: 'dob',
                        name: 'dob'
                    },
                    <?php if(moduleStatusCheck('University')): ?>
                        {
                            data: 'semester_label',
                            name: 'semester_label'
                        }, {
                            data: 'class_sec',
                            name: 'class_sec'
                        },
                    <?php else: ?>
                        {
                            data: 'class_sec',
                            name: 'class_sec'
                        },
                    <?php endif; ?> {
                        data: 'gender.base_setup_name',
                        name: 'gender.base_setup_name'
                    },
                    {
                        data: 'category.category_name',
                        name: 'category.category_name'
                    },
                    {
                        data: 'mobile',
                        name: 'sm_students.mobile'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'first_name',
                        name: 'first_name',
                        visible: false
                    },
                    {
                        data: 'last_name',
                        name: 'last_name',
                        visible: false
                    },
                ],
                bLengthChange: false,
                bDestroy: true,
                language: {
                    search: "<i class='ti-search'></i>",
                    searchPlaceholder: window.jsLang('quick_search'),
                    paginate: {
                        next: "<i class='ti-arrow-right'></i>",
                        previous: "<i class='ti-arrow-left'></i>",
                    },
                },
                dom: "Bfrtip",
                buttons: [{
                        extend: "copyHtml5",
                        text: '<i class="fa fa-files-o"></i>',
                        title: $("#logo_title").val(),
                        titleAttr: window.jsLang('copy_table'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "excelHtml5",
                        text: '<i class="fa fa-file-excel-o"></i>',
                        titleAttr: window.jsLang('export_to_excel'),
                        title: $("#logo_title").val(),
                        margin: [10, 10, 10, 0],
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "csvHtml5",
                        text: '<i class="fa fa-file-text-o"></i>',
                        titleAttr: window.jsLang('export_to_csv'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "pdfHtml5",
                        text: '<i class="fa fa-file-pdf-o"></i>',
                        title: $("#logo_title").val(),
                        titleAttr: window.jsLang('export_to_pdf'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                        orientation: "landscape",
                        pageSize: "A4",
                        margin: [0, 0, 0, 12],
                        alignment: "center",
                        header: true,
                        customize: function(doc) {
                            doc.content[1].margin = [100, 0, 100, 0]; //left, top, right, bottom
                            doc.content.splice(1, 0, {
                                margin: [0, 0, 0, 12],
                                alignment: "center",
                                image: "data:image/png;base64," + $("#logo_img").val(),
                            });
                            doc.defaultStyle = {
                                font: 'DejaVuSans'
                            }
                        },
                    },
                    {
                        extend: "print",
                        text: '<i class="fa fa-print"></i>',
                        titleAttr: window.jsLang('print'),
                        title: $("#logo_title").val(),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "colvis",
                        text: '<i class="fa fa-columns"></i>',
                        postfixButtons: ["colvisRestore"],
                    },
                ],
                columnDefs: [{
                    visible: false,
                }, ],
                responsive: true,
            });
        });
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('backEnd.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ezzypocketschool/public_html/resources/views/backEnd/studentInformation/student_details.blade.php ENDPATH**/ ?>