<?php $__env->startPush('css'); ?>
    <style>
        #table_id1 {
            border: 1px solid var(--border_color);
        }

        #table_id1 td {
            border: 1px solid var(--border_color);
            text-align: center;
        }

        #table_id1 th {
            border: 1px solid var(--border_color);
            text-align: center;
        }

        .main-wrapper {
            display: block;
            width: auto;
            align-items: stretch;
        }

        .main-wrapper {
            display: block;
            width: auto;
            align-items: stretch;
        }

        #main-content {
            width: auto;
        }

        #table_id1 td {
            border: 1px solid var(--border_color);
            text-align: center;
            padding: 7px;
            flex-wrap: nowrap;
            white-space: nowrap;
            font-size: 11px;
            vertical-align: middle;
        }

        .table-responsive::-webkit-scrollbar-thumb {
            background: #828bb2;
            height: 5px;
            border-radius: 0;
        }

        .table-responsive::-webkit-scrollbar {
            width: 5px;
            height: 5px
        }

        .table-responsive::-webkit-scrollbar-track {
            height: 5px !important;
            background: #ddd;
            border-radius: 0;
            box-shadow: inset 0 0 5px grey
        }

        hr {
            margin: 0px;
        }
        .white-box.subject-attendance-table {
            padding: 30px !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php if(isset($subjectAttendance)): ?>
    <div class="col-lg-12 mt-40">
        <div class="white-box">
            <div class="row">
                <div class="col-lg-6 no-gutters">
                    <div class="main-title mb-0">
                        <h3 class="mb-15"><?php echo app('translator')->get('student.monthly_subject_attendance_report'); ?>(<?php echo e(date('F')); ?>)
                        </h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="subject-attendance-table">
                        <div class="lateday d-flex flex-wrap">
                            <div class="mr-3 mb-10"><?php echo app('translator')->get('student.present'); ?>: <span class="text-success">P</span></div>
                            <div class="mr-3 mb-10"><?php echo app('translator')->get('student.late'); ?>: <span class="text-warning">L</span></div>
                            <div class="mr-3 mb-10"><?php echo app('translator')->get('student.absent'); ?>: <span class="text-danger">A</span></div>
                            <div class="mr-3 mb-10"><?php echo app('translator')->get('student.half_day'); ?>: <span class="text-info">F</span></div>
                            <div class="mr-3 mb-10"><?php echo app('translator')->get('student.holiday'); ?>: <span class="text-dark">H</span></div>
                            <div class="mr-3 mb-10"><?php echo app('translator')->get('student.leave'); ?>: <span class="text-muted">Le</span></div>
                        </div>
                        <div class="table-responsive">
                            <?php
                                $weekendDayNames = getWeekendDays(Auth::user()->school_id);
                            ?>
                            <table id="table_id1" class="table table-responsive" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="6%"><?php echo app('translator')->get('common.name'); ?></th>
                                        <th width="6%"><?php echo app('translator')->get('student.admission_no'); ?></th>
                                        <th width="3%">P</th>
                                        <th width="3%">L</th>
                                        <th width="3%">A</th>
                                        <th width="3%">F</th>
                                        <th width="3%">H</th>
                                        <th width="3%">Le</th>
                                        <th width="2%">%</th>
                                        <?php for($i = 1; $i <= $days; $i++): ?>
                                            <th width="3%" class="<?php echo e($i <= 18 ? 'all' : 'none'); ?>">
                                                <?php echo e($i); ?> <br>
                                                <?php
                                                    $date = $year . '-' . $month . '-' . $i;
                                                    $day = date('D', strtotime($date));
                                                    echo $day;
                                                ?>
                                            </th>
                                        <?php endfor; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $p = $l = $a = $f = $h = $le = 0;
                                        $total_attendance = 0;
                                        $count_absent = 0;
                                    ?>
                                    <tr>
                                        <td><?php echo e(@$student_detail->full_name); ?></td>
                                        <td><?php echo e(@$student_detail->admission_no); ?></td>

                                        
                                        <td>
                                            <?php $__currentLoopData = $subjectAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($value->attendance_type == 'P'): ?>
                                                    <?php $p++; $total_attendance++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($p); ?>

                                        </td>

                                        
                                        <td>
                                            <?php $__currentLoopData = $subjectAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($value->attendance_type == 'L'): ?>
                                                    <?php $l++; $total_attendance++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($l); ?>

                                        </td>

                                        
                                        <td>
                                            <?php $__currentLoopData = $subjectAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($value->attendance_type == 'A'): ?>
                                                    <?php $a++; $total_attendance++; $count_absent++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($a); ?>

                                        </td>

                                        
                                        <td>
                                            <?php $__currentLoopData = $subjectAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($value->attendance_type == 'F'): ?>
                                                    <?php $f++; $total_attendance++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($f); ?>

                                        </td>

                                        
                                        <td>
                                            <?php $__currentLoopData = $subjectAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($value->attendance_type == 'H'): ?>
                                                    <?php $h++; $total_attendance++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($h); ?>

                                        </td>

                                        
                                        <td>
                                            <?php $__currentLoopData = $subjectAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($value->attendance_type == 'Le'): ?>
                                                    <?php $le++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($le); ?>

                                        </td>

                                        
                                        <td>
                                            <?php
                                                $total_present = $total_attendance - $count_absent;
                                                $percentage = $total_attendance
                                                    ? number_format(($total_present / $total_attendance) * 100, 2) . '%'
                                                    : '100%';
                                            ?>
                                            <?php echo e($total_present . '/' . $total_attendance); ?>

                                            <hr>
                                            <?php echo e($percentage); ?>

                                        </td>

                                        
                                        <?php for($i = 1; $i <= $days; $i++): ?>
                                            <?php
                                                $date = $year . '-' . str_pad($month, 2, '0', STR_PAD_LEFT) . '-' . str_pad($i, 2, '0', STR_PAD_LEFT);
                                                $dayName = date('l', strtotime($date));
                                                $present = 0;
                                                $absent = 0;
                                                $leave = 0;
                                                $hasAttendance = false;
                                            ?>

                                            <?php $__currentLoopData = $subjectAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($value->attendance_date == $date): ?>
                                                    <?php
                                                        $hasAttendance = true;

                                                        if ($value->attendance_type === 'Le') {
                                                            $leave++;
                                                        } elseif (in_array($value->attendance_type, ['P', 'F', 'L'])) {
                                                            $present++;
                                                        } elseif ($value->attendance_type === 'A') {
                                                            $absent++;
                                                        }
                                                    ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <td width="3%" class="<?php echo e($i <= 18 ? 'all' : 'none'); ?>">
                                                <?php if($hasAttendance): ?>
                                                    <?php if($leave > 0 && $present === 0 && $absent === 0): ?>
                                                        Le
                                                    <?php else: ?>
                                                        <?php echo e($present); ?>/<?php echo e($present + $absent); ?>

                                                        <hr>
                                                        <?php
                                                            $total = $present + $absent;
                                                            echo $total > 0
                                                                ? number_format(($present / $total) * 100, 2) . '%'
                                                                : '0%';
                                                        ?>
                                                    <?php endif; ?>
                                                <?php elseif(in_array($dayName, $weekendDayNames)): ?>
                                                    W
                                                <?php endif; ?>
                                            </td>
                                        <?php endfor; ?>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/ezzypocketschool/public_html/resources/views/backEnd/studentPanel/inc/_dashboard_subject_attendance_tab.blade.php ENDPATH**/ ?>