<?php
$div = isset($div) ? $div : 'col-lg-4';
$mt = isset($mt) ? $mt : 'mb-15';
$subject = isset($subject) ? true : false;
$required = $required ?? [];
$selected = isset($selected) ? $selected : null;

$academic_year = $selected && isset($selected['academic_year']) ? $selected['academic_year'] : null;
$shift_id = $selected && isset($selected['shift_id']) ? $selected['shift_id'] : null;
$class_id = $selected && isset($selected['class_id']) ? $selected['class_id'] : null;
$section_id = $selected && isset($selected['section_id']) ? $selected['section_id'] : null;
$subject_id = $selected && isset($selected['subject_id']) ? $selected['subject_id'] : null;
$student_id = $selected && isset($selected['student_id']) ? $selected['student_id'] : null;

if ($academic_year) {
$classes = classes($academic_year) ?? null;
$sections = $class_id ? sections($class_id, $academic_year) : null;
$subjects = $class_id && $section_id ? subjects($class_id, $section_id, $academic_year) : null;
$students = $class_id && $section_id ? students($class_id, $section_id, $academic_year) : null;
} else {
$sections = $class_id ? sections($class_id) : null;
$subjects = $class_id && $section_id ? subjects($class_id, $section_id) : null;
}
$visiable = $visiable ?? [];

$shift_name = isset($shift_name) ? $shift_name : 'shift';
$class_name = isset($class_name) ? $class_name : 'class';
$section_name = isset($section_name) ? $section_name : 'section';
$subject_name = isset($subject_name) ? $subject_name : 'subject_id';
$academic_name = isset($academic_name) ? $academic_name : 'academic_year';
?>

<?php if(in_array('academic', $visiable)): ?>
<div class="<?php echo e($div . ' ' . $mt); ?>">
    <div class="primary_input ">
        <label class="primary_input_label" for=""><?php echo e(__('common.academic_year')); ?>

            <span class="text-danger"><?php echo e(in_array('academic', $required) ? '*' : ''); ?></span>
        </label>
        <select
            class="primary_select  form-control<?php echo e($errors->has('academic_year') ? ' is-invalid' : ''); ?> common_academic_years"
            name="<?php echo e($academic_name); ?>" id="common_academic_years">
            <option data-display="<?php echo app('translator')->get('common.academic_year'); ?> <?php echo e(in_array('academic', $required) ? '*' : ''); ?>"
                value="">
                <?php echo app('translator')->get('common.academic_year'); ?> <?php echo e(in_array('academic', $required) ? '*' : ''); ?>

            </option>
            <?php if(isset($sessions)): ?>
            <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            <option value="<?php echo e($session->id); ?>"
                <?php echo e(old($academic_name, $academic_year ?? getAcademicId()) == $session->id ? 'selected' : ''); ?>>
                <?php echo e($session->year); ?>[<?php echo e($session->title); ?>]
            </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

        </select>

        <?php if($errors->has($academic_name)): ?>
            <span class="text-danger" role="alert">
                <?php echo e($errors->first($academic_name)); ?>

            </span>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>

<?php if(shiftEnable()): ?>
    <?php if(in_array('shift', $visiable)): ?>
        <div class="<?php echo e($div . ' ' . $mt); ?>">
            <div class="primary_input " id="common_select_shifts_div">
                <label class="primary_input_label" for=""><?php echo e(__('common.shift')); ?>

                    <span class="text-danger"><?php echo e(in_array('shift', $required) ? '*' : ''); ?></span>
                </label>
                <select class="primary_select form-control<?php echo e($errors->has('shift') ? ' is-invalid' : ''); ?>" name="<?php echo e($shift_name); ?>"
                    id="common_select_shifts">
                    <option data-display="<?php echo app('translator')->get('common.select_shift'); ?> <?php echo e(in_array('shift', $required) ? '*' : ''); ?>" value="">
                        <?php echo e(__('common.select_shift')); ?> <?php echo e(in_array('shift', $required) ? '*' : ''); ?></option>
                    <?php $__currentLoopData = shifts(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <option value="<?php echo e($shift->id); ?>"
                            <?php echo e(old('shift', $shift_id ?? '') == $shift->id ? 'selected' : ''); ?>>
                            <?php echo e($shift->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <div class="pull-right loader loader_style" id="common_select_shifts_loader">
                    <img class="loader_img_style" src="<?php echo e(asset('public/backEnd/img/demo_wait.gif')); ?>" alt="loader">
                </div>
                <span class="text-danger"><?php echo e($errors->first('shift')); ?></span>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
<?php if(in_array('class', $visiable)): ?>
<div class="<?php echo e($div . ' ' . $mt); ?>" id="common_select_classes_div">
    <div class="primary_input mb-25">
        <label class="primary_input_label" for=""><?php echo e(__('common.class')); ?>

            <span class="text-danger"><?php echo e(in_array('class', $required) ? '*' : ''); ?></span>
        </label>
        <select class="primary_select form-control<?php echo e($errors->has('class_id') ? ' is-invalid' : ''); ?>" name="<?php echo e($class_name); ?>"
            id="common_select_classes">
            <option data-display="<?php echo app('translator')->get('common.select_class'); ?> <?php echo e(in_array('class', $required) ? '*' : ''); ?>" value="">
                <?php echo e(__('common.select_class')); ?> <?php echo e(in_array('class', $required) ? '*' : ''); ?></option>
            <?php if(isset($classes)): ?>
            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($class->id); ?>"
                <?php echo e(old($class_name, $class_id ?? '') == $class->id ? 'selected' : ''); ?>>
                <?php echo e($class->class_name); ?>

            </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </select>
        <div class="pull-right loader loader_style" id="common_select_classes_loader">
            <img class="loader_img_style" src="<?php echo e(asset('public/backEnd/img/demo_wait.gif')); ?>" alt="loader">
        </div>
        <span class="text-danger"><?php echo e($errors->first($class_name)); ?></span>
    </div>
</div>
<?php endif; ?>

<?php if(in_array('section', $visiable)): ?>
<div class="<?php echo e($div . ' ' . $mt); ?>" id="common_select_sections_div">
    <label class="primary_input_label" for=""><?php echo e(__('common.section')); ?>

        <span class="text-danger"><?php echo e(in_array('section', $required) ? '*' : ''); ?></span>
    </label>
    <select class="primary_select form-control<?php echo e($errors->has('section_id') ? ' is-invalid' : ''); ?> select_section"
        id="common_select_sections" name="<?php echo e($section_name); ?>">
        <option data-display="<?php echo app('translator')->get('common.select_section'); ?> <?php echo e(in_array('section', $required) ? '*' : ''); ?>" value="">
            <?php echo app('translator')->get('common.select_section'); ?> <?php echo e(in_array('section', $required) ? '*' : ''); ?></option>
        
        <?php if(old($class_name)): ?>
            <?php
                $sections = collect();
                if (old($class_name)) {
                    $sections = App\SmClassSection::where('class_id', old($class_name))
                        ->where('school_id', Auth::user()->school_id)
                        ->get();
                }
            ?>
            <?php if(isset($sections)): ?>
                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($section->section_id); ?>"
                    <?php echo e(old($section_name, $section_id ?? '') == $section->section_id ? 'selected' : ''); ?>>
                    <?php echo e($section->sectionName->section_name); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php else: ?>
            <?php if(isset($sections)): ?>
                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($section->id); ?>"
                    <?php echo e(isset($section_id) ? ($section_id == $section->section_id ? 'selected' : '') : ''); ?>>
                    <?php echo e($section->sectionName->section_name); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php endif; ?>
        
    </select>
    <div class="pull-right loader loader_style" id="common_select_sections_loader" style="margin-top: -30px;padding-right: 21px;">
        <img src="<?php echo e(asset('public/backEnd/img/demo_wait.gif')); ?>" alt="" style="width: 28px;height:28px;">
    </div>


    <?php if($errors->has($section_name)): ?>
    <span class="text-danger">
        <?php echo e($errors->first($section_name)); ?>

    </span>
    <?php endif; ?>
</div>
<?php endif; ?>

<?php if(in_array('subject', $visiable)): ?>
<div class="<?php echo e($div . ' ' . $mt); ?>" id="common_select_subject_div">
    <label class="primary_input_label" for=""><?php echo e(__('common.subject')); ?>

        <span class="text-danger"><?php echo e(in_array('subject', $required) ? '*' : ''); ?></span>
    </label>
    <select class="primary_select form-control<?php echo e($errors->has('subject_id') ? ' is-invalid' : ''); ?> select_subject"
        id="common_select_subject" name="<?php echo e($subject_name); ?>">
        <option data-display="<?php echo app('translator')->get('common.select_subject'); ?> <?php echo e(in_array('subject', $required) ? ' *' : ''); ?>" value="">
            <?php echo app('translator')->get('common.select_subject'); ?> <?php echo e(in_array('subject', $required) ? ' *' : ''); ?></option>
        <?php if(isset($subjects)): ?>
        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
        <option value="<?php echo e($subject->subject_id); ?>"
            <?php echo e(old($subject_name, $subject_id ?? '') == $subject->subject_id ? 'selected' : ''); ?>>
            <?php echo e($subject->subject->subject_name); ?>

        </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </select>
    <div class="pull-right loader loader_style" id="common_select_subject_loader" style="margin-top: -30px;padding-right: 21px;">
        <img src="<?php echo e(asset('public/backEnd/img/demo_wait.gif')); ?>" alt="" style="width: 28px;height:28px;">
    </div>

    <?php if($errors->has($subject_name)): ?>
    <span class="text-danger">
        <?php echo e($errors->first($subject_name)); ?>

    </span>
    <?php endif; ?>
</div>
<?php endif; ?>
<?php if(in_array('student', $visiable)): ?>
<div class="<?php echo e($div . ' ' . $mt); ?>" id="common_select_student_div">
    <label class="primary_input_label" for=""><?php echo e(__('common.student')); ?>

        <span class="text-danger"><?php echo e(in_array('student', $required) ? '*' : ''); ?></span>
    </label>
    <select class="primary_select form-control<?php echo e($errors->has('student') ? ' is-invalid' : ''); ?>"
        id="common_select_student" name="student">
        <option data-display="<?php echo app('translator')->get('reports.select_student'); ?> <?php echo e(in_array('student', $required) ? '*' : ''); ?>" value="">
            <?php echo app('translator')->get('reports.select_student'); ?> <span><?php echo e(in_array('student', $required) ? '*' : ''); ?></span>
        </option>
        <?php if(isset($students)): ?>
        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
        <option value="<?php echo e($student->id); ?>"
            <?php echo e(old('student', $student_id ?? '') == $student->id ? 'selected' : ''); ?>>
            <?php echo e($student->full_name); ?>

        </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </select>

    <div class="pull-right loader loader_style" id="common_select_student_loader">
        <img class="loader_img_style" src="<?php echo e(asset('public/backEnd/img/demo_wait.gif')); ?>" alt="loader">
    </div>

    <?php if($errors->has('student')): ?>
    <span class="text-danger">
        <?php echo e($errors->first('student')); ?>

    </span>
    <?php endif; ?>
</div>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function () {
        let class_required = "<?php echo e(in_array('class', $required) ? ' *' : ''); ?>";
        let shift_required = "<?php echo e(in_array('shift', $required) ? ' *' : ''); ?>";
        let section_required = "<?php echo e(in_array('section', $required) ? ' *' : ''); ?>";
        let subject_required = "<?php echo e(in_array('subject', $required) ? ' *' : ''); ?>";
        let student_required = "<?php echo e(in_array('student', $required) ? ' *' : ''); ?>";
        $("#common_academic_years").on(
            "change",
            function () {
                var url = $("#url").val();
                var i = 0;
                var formData = {
                    id: $(this).val(),
                };

                // get class
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "academic-year-get-class",

                    beforeSend: function () {
                        $('#common_select_classes_loader').addClass('pre_loader').removeClass(
                            'loader');
                    },

                    success: function (data) {
                        $("#common_select_classes").empty().append(
                            $("<option>", {
                                value: '',
                                text: window.jsLang('select_class') + class_required,
                            })
                        );

                        if (data[0].length) {
                            $.each(data[0], function (i, className) {
                                $("#common_select_classes").append(
                                    $("<option>", {
                                        value: className.id,
                                        text: className.class_name,
                                    })
                                );
                            });
                        }
                        $('#common_select_classes').niceSelect('update');
                        $('#common_select_classes').trigger('change');
                    },
                    error: function (data) {
                        console.log('Error:', data);
                    },
                    complete: function () {
                        i--;
                        if (i <= 0) {
                            $('#common_select_classes_loader').removeClass('pre_loader').addClass(
                                'loader');
                        }
                    }
                });
            }
        );

        <?php if(shiftEnable()): ?>
        $("#common_academic_years").on("change", function () {
            var url = $("#url").val();
            var i = 0;
            var selectedAcademicId = $("#common_academic_years").val();

            $.ajax({
                type: "GET",
                data: { id: selectedAcademicId },
                dataType: "json",
                url: url + "/" + "academic-year-get-shift",

                beforeSend: function () {
                    $('#common_select_shifts_loader').addClass('pre_loader').removeClass('loader');
                },

                success: function (data) {
                    $("#common_select_shifts").empty().append(
                        $("<option>", {
                            value: '',
                            text: window.jsLang('select_shift') + shift_required,
                        })
                    );

                    if (data.length && Array.isArray(data[0])) {
                        const shifts = data[0];
                        
                        $.each(shifts, function (i, shift) {
                            $("#common_select_shifts").append(
                                $("<option>", {
                                    text: shift.name,
                                    value: shift.id,
                                })
                            );
                        });
                    }

                    $('#common_select_shifts').niceSelect('update');
                    // auto select off, so no trigger('change')
                },

                error: function (data) {
                    console.log('Error:', data);
                },
                complete: function () {
                    i--;
                    if (i <= 0) {
                        $('#common_select_shifts_loader').removeClass('pre_loader').addClass('loader');
                    }
                }
            });
        });
        $("#common_select_shifts").on("change", function () {
            var url = $("#url").val();
            var i = 0;
            var selectedShiftId = $(this).val();
            if ($('#common_academic_years_div').length) {
                academic_id = $('#common_academic_years_div').find(":selected").val();
            }else{
                academic_id = '';
            }

            $.ajax({
                type: "GET",
                data: { 
                    id: selectedShiftId,
                    academic_id: academic_id ? academic_id : '',
                },
                dataType: "json",
                url: url + "/" + "shift-get-class",

                beforeSend: function () {
                    $('#common_select_classes_loader').addClass('pre_loader').removeClass('loader');
                },

                success: function (data) {
                    $("#common_select_classes").empty().append(
                        $("<option>", {
                            value: '',
                            text: window.jsLang('select_class') + class_required,
                        })
                    );

                    if (data.length) {
                        $.each(data, function (i, className) {
                            $("#common_select_classes").append(
                                $("<option>", {
                                    value: className.id,
                                    text: className.class_name,
                                })
                            );
                        });
                    }

                    $('#common_select_classes').niceSelect('update');
                    // auto select off, so no trigger('change')
                },

                error: function (data) {
                    console.log('Error:', data);
                },
                complete: function () {
                    i--;
                    if (i <= 0) {
                        $('#common_select_classes_loader').removeClass('pre_loader').addClass('loader');
                    }
                }
            });
        });
        <?php else: ?>
        $("#common_academic_years").on("change", function () {
            var url = $("#url").val();
            var i = 0;
            var selectedAcademicId = $("#common_academic_years").val();

            $.ajax({
                type: "GET",
                data: { id: selectedAcademicId },
                dataType: "json",
                url: url + "/" + "academic-year-get-class",

                beforeSend: function () {
                    $('#common_select_classes_loader').addClass('pre_loader').removeClass('loader');
                },

                success: function (data) {
                    $("#common_select_classes").empty().append(
                        $("<option>", {
                            value: '',
                            text: window.jsLang('select_class') + class_required,
                        })
                    );

                    if (data.length) {
                        $.each(data, function (i, className) {
                            $("#common_select_classes").append(
                                $("<option>", {
                                    value: className.id,
                                    text: className.name,
                                })
                            );
                        });
                    }

                    $('#common_select_classes').niceSelect('update');
                },

                error: function (data) {
                    console.log('Error:', data);
                },
                complete: function () {
                    i--;
                    if (i <= 0) {
                        $('#common_select_classes_loader').removeClass('pre_loader').addClass('loader');
                    }
                }
            });
        });
        <?php endif; ?>

        $("#common_select_classes").on("change", function () {

            var url = $("#url").val();
            var i = 0;
            var formData = {
                id: $(this).val(),
            };
            $.ajax({
                type: "GET",
                data: formData,
                dataType: "json",
                url: url + "/" + "ajaxStudentPromoteSection",

                beforeSend: function () {
                    $('#common_select_sections_loader').addClass('pre_loader').removeClass(
                        'loader');
                },
                success: function (data) {
                    $("#common_select_sections").empty().append(
                        $("<option>", {
                            value: '',
                            text: window.jsLang('select_section') +
                                section_required,
                        })
                    );

                    if (data[0].length) {
                        $.each(data[0], function (i, section) {
                            $("#common_select_sections").append(
                                $("<option>", {
                                    value: section.id,
                                    text: section.section_name,
                                })
                            );
                        });
                    }
                    $('#common_select_sections').niceSelect('update');
                    $('#common_select_sections').trigger('change');

                },
                error: function (data) {
                    console.log("Error:", data);
                },
                complete: function () {
                    i--;
                    if (i <= 0) {
                        $('#common_select_sections_loader').removeClass('pre_loader')
                            .addClass('loader');
                    }
                }
            });
        });
        $("#common_select_sections").on("change", function () {
            var url = $("#url").val();
            var i = 0;
            var subject = "<?php echo e($subject); ?>";
            var select_class = $("#common_select_classes").val();
            var class_id = $("#common_select_classes").val();
            var section_id = $(this).val();

            var formData = {
                section: $(this).val(),
                class: $("#common_select_classes").val(),
            };
            // get section for student
            if(subject == false)
            {
            $.ajax({
                type: "GET",
                data: formData,
                dataType: "json",
                url: url + "/" + "ajaxSelectStudent",

                beforeSend: function () {
                    $('#common_select_student_loader').addClass('pre_loader').removeClass(
                        'loader');
                },

                success: function (data) {

                    $("#common_select_student").empty().append(
                        $("<option>", {
                            value: '',
                            text: window.jsLang('select_student') +
                                student_required,
                        })
                    );

                    if (data[0].length) {
                        $.each(data[0], function (i, student) {
                            $("#common_select_student").append(
                                $("<option>", {
                                    value: student.id,
                                    text: student.full_name,
                                })
                            );
                        });
                    }
                    $('#common_select_student').niceSelect('update');
                    $('#common_select_student').trigger('change');
                },
                error: function (data) {
                    console.log("Error:", data);
                },
                complete: function () {
                    i--;
                    if (i <= 0) {
                        $('#common_select_student_loader').removeClass('pre_loader')
                            .addClass('loader');
                    }
                }
            });
            }
            // get subject from section
            if(subject == true)
            {
                getSubject(class_id, section_id);
            }
        });

        function getSubject(class_id, section_id) {
            var url = $("#url").val();
            var i = 0;
            $.ajax({
                type: "GET",
                data: {class: class_id, section: section_id},
                dataType: "json",
                url: url + "/" + "ajaxSelectSubject",

                beforeSend: function () {
                    $('#common_select_student_loader').addClass('pre_loader').removeClass('loader');
                },

                success: function (data) {

                    $("#common_select_subject").empty().append(
                        $("<option>", {
                            value: '',
                            text: window.jsLang('select_subject'),
                        })
                    );

                    if (data[0].length) {
                        $.each(data[0], function (i, subject) {
                            $("#common_select_subject").append(
                                $("<option>", {
                                    value: subject.id,
                                    text: subject.subject_name,
                                })
                            );
                        });
                    }
                    $('#common_select_subject').niceSelect('update');
                    $('#common_select_subject').trigger('change');
                },
                error: function (data) {
                    console.log("Error:", data);
                },
                complete: function () {
                    i--;
                    if (i <= 0) {
                        $('#common_select_student_loader').removeClass('pre_loader').addClass(
                            'loader');
                    }
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/ezzypocketschool/public_html/resources/views/backEnd/common/search_criteria.blade.php ENDPATH**/ ?>