<?php

return [
    'name' => 'KouffeSaas',
    'alias' => 'kouffe-saas-addon',
    'version' => '1.0.0',
    
    /*
    |--------------------------------------------------------------------------
    | Domain Configuration
    |--------------------------------------------------------------------------
    */
    'base_domain' => env('KOUFFE_SAAS_BASE_DOMAIN', 'kouffe.com'),
    'wildcard_enabled' => env('KOUFFE_SAAS_WILDCARD_ENABLED', true),
    
    /*
    |--------------------------------------------------------------------------
    | Subscription Configuration
    |--------------------------------------------------------------------------
    */
    'trial_days' => env('KOUFFE_SAAS_TRIAL_DAYS', 14),
    'auto_renewal' => env('KOUFFE_SAAS_AUTO_RENEWAL', true),
    
    /*
    |--------------------------------------------------------------------------
    | Payment Configuration
    |--------------------------------------------------------------------------
    */
    'payment_methods' => [
        'stripe' => [
            'enabled' => env('KOUFFE_SAAS_STRIPE_ENABLED', true),
            'key' => env('STRIPE_KEY'),
            'secret' => env('STRIPE_SECRET'),
        ],
        'paypal' => [
            'enabled' => env('KOUFFE_SAAS_PAYPAL_ENABLED', true),
            'client_id' => env('PAYPAL_CLIENT_ID'),
            'client_secret' => env('PAYPAL_CLIENT_SECRET'),
            'mode' => env('PAYPAL_MODE', 'sandbox'),
        ],
    ],
    
    /*
    |--------------------------------------------------------------------------
    | License Configuration
    |--------------------------------------------------------------------------
    */
    'license' => [
        'api_url' => env('KOUFFE_SAAS_LICENSE_API', 'https://auth.uxseven.com/api/license'),
        'verify_interval' => env('KOUFFE_SAAS_LICENSE_VERIFY_INTERVAL', 3600), // seconds
    ],
];

