<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('saas_subscriptions', function (Blueprint $table) {
            // InnoDB nécessaire pour les clés étrangères
            $table->engine = 'InnoDB';

            $table->id();
            // Alignement sur sm_schools.id (int unsigned dans InfixEdu)
            $table->unsignedInteger('school_id');
            $table->unsignedBigInteger('plan_id');
            $table->string('status')->default('pending'); // pending, active, expired, cancelled
            $table->dateTime('start_date');
            $table->dateTime('end_date');
            $table->dateTime('trial_ends_at')->nullable();
            $table->string('payment_method')->nullable(); // stripe, paypal
            $table->string('payment_id')->nullable(); // External payment ID
            $table->boolean('auto_renew')->default(true);
            $table->dateTime('cancelled_at')->nullable();
            $table->text('cancellation_reason')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('school_id')->references('id')->on('sm_schools')->onDelete('cascade');
            $table->foreign('plan_id')->references('id')->on('saas_plans')->onDelete('restrict');
            $table->index(['school_id', 'status']);
            $table->index('end_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('saas_subscriptions');
    }
};

