# Guide d'Installation - Module Kouffe SaaS

## Prérequis

- Laravel 8.x ou supérieur
- InfixEdu installé et fonctionnel
- PHP 7.4 ou supérieur
- MySQL/MariaDB
- Extension cURL activée
- Composer installé

## Installation

### 1. Copier le module

Copiez le répertoire `KouffeSaas` dans `modules/KouffeSaas` de votre installation InfixEdu.

### 2. Installer les dépendances

```bash
composer require stripe/stripe-php
```

### 3. Exécuter les migrations

```bash
php artisan migrate --path=modules/KouffeSaas/Database/Migrations
```

### 4. Publier la configuration

```bash
php artisan vendor:publish --tag=kouffesaas-config
```

### 5. Configurer les variables d'environnement

Ajoutez dans votre fichier `.env`:

```env
# Kouffe SaaS Configuration
KOUFFE_SAAS_BASE_DOMAIN=kouffe.com
KOUFFE_SAAS_WILDCARD_ENABLED=true
KOUFFE_SAAS_TRIAL_DAYS=14
KOUFFE_SAAS_AUTO_RENEWAL=true

# Stripe Configuration
STRIPE_KEY=pk_test_...
STRIPE_SECRET=sk_test_...

# PayPal Configuration
PAYPAL_CLIENT_ID=your_paypal_client_id
PAYPAL_CLIENT_SECRET=your_paypal_client_secret
PAYPAL_MODE=sandbox

# License API
KOUFFE_SAAS_LICENSE_API=https://auth.uxseven.com/api/license
KOUFFE_SAAS_LICENSE_VERIFY_INTERVAL=3600
```

### 6. Enregistrer le module

Le module doit être enregistré dans le système de modules InfixEdu. Utilisez l'interface d'administration pour activer le module avec:
- **ID du Module**: `kouffe-saas-addon`
- **Version**: `1.0.0`
- **Item ID**: (fourni lors de l'achat)
- **Checksum**: (fourni lors de l'achat)

### 7. Configurer le DNS pour les sous-domaines wildcard

Pour activer les sous-domaines wildcard (ex: `{school}.kouffe.com`), configurez votre DNS:

```
*.kouffe.com    A    YOUR_SERVER_IP
```

### 8. Configurer le serveur web

#### Apache (.htaccess)

Ajoutez dans votre `.htaccess`:

```apache
RewriteCond %{HTTP_HOST} ^([^.]+)\.kouffe\.com$ [NC]
RewriteRule ^(.*)$ /index.php [L]
```

#### Nginx

Ajoutez dans votre configuration Nginx:

```nginx
server {
    listen 80;
    server_name *.kouffe.com;
    root /path/to/your/project/public;
    
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### 9. Configurer le cron pour les vérifications automatiques

Ajoutez dans votre crontab:

```cron
# Vérification quotidienne des abonnements
0 0 * * * cd /path-to-your-project && php artisan kouffe-saas:check-subscriptions >> /dev/null 2>&1

# Application des limites (optionnel, peut être exécuté manuellement)
0 2 * * * cd /path-to-your-project && php artisan kouffe-saas:enforce-limits >> /dev/null 2>&1
```

### 10. Enregistrer les middlewares

Dans `app/Http/Kernel.php`, ajoutez:

```php
protected $middlewareGroups = [
    'web' => [
        // ... autres middlewares
        \Modules\KouffeSaas\Middleware\MapSchoolToRequest::class,
    ],
    
    'api' => [
        // ... autres middlewares
        \Modules\KouffeSaas\Middleware\MapSchoolToRequest::class,
    ],
];

protected $routeMiddleware = [
    // ... autres middlewares
    'enforce.limits' => \Modules\KouffeSaas\Middleware\EnforceSubscriptionLimits::class,
];
```

## Activation du module

1. Connectez-vous en tant que Super Admin
2. Allez dans **Modules** > **Gérer les modules**
3. Trouvez "Kouffe SaaS" et cliquez sur **Activer**
4. Entrez les informations de licence (Item ID et Checksum)
5. Le module sera activé et les plans par défaut seront créés

## Vérification

Après l'installation, vérifiez que:

1. Les tables sont créées dans la base de données:
   - `saas_plans`
   - `saas_subscriptions`
   - `saas_custom_domains`
   - `saas_invoices`

2. Les plans par défaut sont créés:
   - Trial (gratuit, 14 jours)
   - Basic ($49.99/mois)
   - Premium ($149.99/mois)

3. Les routes sont accessibles:
   - `/admin/kouffe-saas/dashboard` (Super Admin)
   - `/school/kouffe-saas/dashboard` (School Admin)

## Dépannage

### Le module ne s'active pas

- Vérifiez que le fichier `KouffeSaas.json` existe et contient les bonnes informations
- Vérifiez la connexion à l'API de licence (auth.uxseven.com)
- Vérifiez les logs Laravel pour les erreurs

### Les sous-domaines ne fonctionnent pas

- Vérifiez la configuration DNS
- Vérifiez la configuration du serveur web (Apache/Nginx)
- Vérifiez que le middleware `MapSchoolToRequest` est bien enregistré

### Les paiements ne fonctionnent pas

- Vérifiez les clés API Stripe/PayPal dans `.env`
- Vérifiez que les routes de paiement sont accessibles
- Vérifiez les logs pour les erreurs de paiement

## Support

Pour toute assistance, contactez: support@kouffe.com

